import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

export const fetchAllProductListings = async ({ productId, query = {} }) => {
  const url = `/products/${productId}/listings`

  try {
    const { data } = await axiosConfig.get(url, buildUrlParams(query))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const fetchProductListingById = async (listingId) => {
  const url = `/product-listings/${listingId}`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const editProductListingById = async (listingId, sendData) => {
  const url = `/product-listings/${listingId}`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const fetchProductListingInventoryMovements = async (listingId, options = {}) => {
  const url = `/product-listings/${listingId}/inventory-movements`

  try {
    const { data } = await axiosConfig.get(url, buildUrlParams(query))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
