import axiosConfig from '@/config/axiosConfig'

const baseURL = '/products'

export const createBlemishedProduct = async (sendData) => {
  const url = `${baseURL}/blemished`

  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
export const generateBlemishedSku = async (productId) => {
  const url = `${baseURL}/generate-sku-pattern/${productId}`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updateSettings = async (payload) => {
  const url = 'settings/blemished-sku-pattern'
  try {
    const { data } = await axiosConfig.put(url, { ...payload })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const settingsBlemishedSkuPatternSettings = async () => {
  const url = 'settings/blemished-sku-pattern'
  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const lpnLookup = async (amazonIntegrationInstance, lpn) => {
  const url = `/amazon/${amazonIntegrationInstance}/lpn-lookup?lpn=${lpn}`
  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
