import axiosConfig from '../config/axiosConfig'

const baseURL = '/attributes'

// Get All Product Attributes
export const getAllProductAttributes = async () => {
  try {
    const { data } = await axiosConfig.get(baseURL)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create or Update Attribute
export const createOrUpdateAttribute = async (attributeData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...attributeData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
