import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/product-pricing-tiers'

export const getAllPricingTiers = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Pricing Tier
export const createPricingTier = async (pricingTierData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...pricingTierData })
    return data
  } catch (e) {

    if (e.response) {
      return e.response
    }
  }
}

// Update Pricing Tier
export const updatePricingTier = async (PricingTierID, PricingTierData) => {
  const url = `${baseURL}/${PricingTierID}`

  try {
    const { data } = await axiosConfig.put(url, { ...PricingTierData })
    return data
  } catch (e) {

    if (e.response) {
      return e.response
    }
  }
}

// set is default  Pricing Tier
export const setIsDefaultPricingTier = async (PricingTierID) => {
  const url = `${baseURL}/${PricingTierID}/default`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {

    if (e.response) {
      return e.response
    }
  }
}

export const archivePricingTierByID = async (id) => {
  const url = `${baseURL}/${id}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchivePricingTierByID = async (id) => {
  const url = `${baseURL}/${id}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archivePricingTiers = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchivePricingTiers = async (sendData) => {
  const url = `${baseURL}/unarchive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deletePricingTierByID = async (id) => {
  const url = `${baseURL}/${id}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deletePricingTiers = async (sendData) => {
  try {
    const { data } = await axiosConfig.delete(baseURL, { params: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Bulk check deleatbility
export const isDeletable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/deletable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// check pricing tiers archivablity
export const isArchivable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/archivable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const previewPricingTiersImport = async (sendData) => {
  const url = `${baseURL}/import/preview`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const importPricingTiersData = async (sendData) => {
  const url = `${baseURL}/import`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
