import axiosConfig from '../config/axiosConfig'

const baseURL = '/payment-types'

export const getPaymentTypes = async (query) => {
  try {
    const { data } = await axiosConfig.get(baseURL, {params: query})
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const createPaymentType = async (payload) => {
  try {
    const { data } = await axiosConfig.post(baseURL, payload)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updatePaymentType = async (typeId, payload) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/${typeId}`, payload)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
export const updatePaymentTypes = async (payload) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/bulk-update`, payload)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deletePaymentType = async (typeId) => {
  const url = `${baseURL}/${typeId}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const isTypeDeletable = async (typeId) => {
  const url = `${baseURL}/deletable`

  try {
    const { data } = await axiosConfig.post(url, { ids: [typeId] })
    return data.data[0]
  } catch (e) {
    return Promise.reject(e)
  }
}

export const mappingPaymentTypes = async (payload) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/accounting-mapping`, payload)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
