import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/payment-terms'

// Get All Payment Terms
export const getAllPaymentTerms = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Get Payment Term by ID
export const getPaymentTermByID = async (paymentTermID) => {
  const url = `${baseURL}/${paymentTermID}`

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Payment Term
export const createPaymentTerm = async (paymentTermData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...paymentTermData })
    return data
  } catch (e) {
    if (e.response) {
      return e.response
    }
  }
}

// Update Payment Term
export const updatePaymentTerm = async (paymentTermID, paymentTermData) => {
  const url = `${baseURL}/${paymentTermID}`

  try {
    const { data } = await axiosConfig.put(url, { ...paymentTermData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archivePaymentTermByID = async (id) => {
  const url = `${baseURL}/${id}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchivePaymentTermByID = async (id) => {
  const url = `${baseURL}/${id}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archivePaymentTerms = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchivePaymentTerms = async (sendData) => {
  const url = `${baseURL}/unarchive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deletePaymentTermByID = async (id) => {
  const url = `${baseURL}/${id}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deletePaymentTerms = async (sendData) => {
  try {
    const { data } = await axiosConfig.delete(baseURL, { params: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Bulk check deleatbility
export const isDeletable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/deletable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
