import axiosConfig from '../config/axiosConfig'

const getUrl = (entity) => {
  return `/export/${entity}/packing-slips`
}

const getPackingSlipsRequest = async (entity, params) => {
  try {
    const { data } = await axiosConfig.get(getUrl(entity), { params })
    return data
  } catch ({ response }) {
    return response.data
  }
}

export const getFulfillmentsPackingSlips = async (params) => {
  return getPackingSlipsRequest('sales-order-fulfillments', params)
}

export const getOrdersPackingSlips = async (params) => {
  return getPackingSlipsRequest('sales-orders', params)
}
