import axiosConfig from '../config/axiosConfig'
import axios from 'axios'

const CancelToken = axios.CancelToken
let cancelLookupRequest = () => false
const baseURL = '/lookup'

export const lookupProductValues = async ({ value, header, page, limit }) => {
  return lookupValues('products', { value, header, page, limit })
}

export const lookupOrdersValues = async ({ value, header, page, limit }) => {
  return lookupValues('sales-orders', { value, header, page, limit })
}

export const lookupShipByScheduleValues = async ({ value, header, page, limit }) => {
  return lookupValues('ship-by-schedule', { value, header, page, limit })
}

export const lookupPurchaseOrdersValues = async ({ value, header, page, limit }) => {
  return lookupValues('purchase-orders', { value, header, page, limit })
}

export const lookupSalesOrderLineFinancialsValues = async ({ value, header, page, limit }) => {
  return lookupValues('sales-order-line-financials', { value, header, page, limit })
}

export const lookupStockTakesValues = async ({ value, header, page, limit }) => {
  return lookupValues('stock-takes', { value, header, page, limit })
}

export const lookupListingsValues = async ({ instanceId, value, header, page, limit }) => {
  return lookupValues(`integration-instances/${instanceId}/listings`, { value, header, page, limit })
}

export const lookupInventoryAdjustmentsValues = async ({ value, header, page, limit }) => {
  return lookupValues('inventory-adjustments', { value, header, page, limit })
}

export const lookupInventoryMovementValues = async ({ value, header, page, limit }) => {
  return lookupValues('inventory-movements', { value, header, page, limit })
}

export const lookupBackorderValues = async ({ value, header, page, limit }) => {
  return lookupValues('backorder-queues', { value, header, page, limit })
}

export const lookupFulfillmentsValues = async ({ value, header, page, limit }) => {
  return lookupValues('sales-order-fulfillments', { value, header, page, limit })
}

export const lookupAccountingTransactions = async ({ value, header, page, limit }) => {
  return lookupValues('accounting-transactions', { value, header, page, limit })
}

export const lookupAccountingPayments = async ({ value, header, page, limit }) => {
  return lookupValues('accounting-payments', { value, header, page, limit })
}

export const lookupTags = async ({ value, header, page, limit }) => {
  return lookupValues('tags', { value, header, page, limit })
}

export const lookupValues = async (resource, { value, header, page, limit }) => {
  // cancel any pending request
  cancelLookupRequest('cancel previous lookup request')
  // create cancel token
  let cancelToken = new CancelToken(function executor (c) {
    // An executor function receives a cancel function as a parameter
    cancelLookupRequest = c
  })
  let url = `${baseURL}/${resource}?value=${value}&input=${header.value}&page=${page}&limit=${limit}`

  try {
    const { data } = await axiosConfig.get(url, { cancelToken })

    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
