import axiosConfig from '../config/axiosConfig'

const baseURL = '/inventory-management'

export const getInventoryForecastingSettings = async () => {
  const url = '/settings/inventory-forecasting'

  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updateSettingsInventoryForecasting = async (settings) => {
  const url = '/settings/inventory-forecasting'

  try {
    const { data } = await axiosConfig.put(url, { ...settings })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getAgingInventory = async () => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/aging-inventory`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getInventoryValuation = async () => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/valuation`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getInventoryValuationByProduct = async (params) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/valuation-by-product`, { params })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
