import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/inventory-adjustments'

export const getInventoryAdjustments = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getInventoryAdjustmentById = async (adjustmentId) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/${adjustmentId}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const createInventoryAdjustment = async (sendData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updateInventoryAdjustment = async (id, sendData) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/${id}`, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archiveInventoryAdjustmentByID = async (id) => {
  const url = `${baseURL}/${id}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveInventoryAdjustmentByID = async (id) => {
  const url = `${baseURL}/${id}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archiveInventoryAdjustments = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveInventoryAdjustments = async (sendData) => {
  const url = `${baseURL}/unarchive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteInventoryAdjustmentByID = async (id) => {
  const url = `${baseURL}/${id}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteInventoryAdjustments = async (sendData) => {
  try {
    const { data } = await axiosConfig.delete(baseURL, { params: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const checkIfDeletableInventoryAdjustments = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/deletable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
