import axiosConfig from '../config/axiosConfig'

const baseUrl = '/magento'

export const getMagentoProductAttributes = async (instanceId, query = null) => {
  const url = `${baseUrl}/${instanceId}/product-attributes`
  const options = query ? { params: { query, limit: -1 } } : { params: {limit: -1} }
  try {
    const { data } = await axiosConfig.get(url, options)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const downloadMagentoInventorySources = async (instanceId) => {
  const url = `${baseUrl}/${instanceId}/inventory-sources`
  try {
    const { data } = await axiosConfig.post(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
