import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/incoterms'

export const getAllIncoterms = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Incoterm
export const createIncoterm = async (incotermData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...incotermData })
    return data
  } catch (e) {
    if (e) {
      return e.response
    }
  }
}

// Update Incoterm
export const updateIncoterm = async (incotermID, incotermData) => {
  const url = `${baseURL}/${incotermID}`

  try {
    const { data } = await axiosConfig.put(url, { ...incotermData })
    return data
  } catch (e) {
    if (e) {
      return e.response
    }
  }
}

// Archive Incoterm By ID
export const archiveIncotermByID = async (incotermID) => {
  const url = `${baseURL}/${incotermID}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveIncotermByID = async (incotermID) => {
  const url = `${baseURL}/${incotermID}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Archive Incoterms By IDs or filter
export const archiveIncoterms = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Unarchive Incoterms By IDs or filter
export const unarchiveIncoterms = async (sendData) => {
  const url = `${baseURL}/unarchive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete Incoterm By ID
export const deleteIncotermByID = async (incotermID) => {
  const url = `${baseURL}/${incotermID}`

  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Delete Incoterms By IDs or filter
export const deleteIncoterms = async (sendData) => {
  try {
    const { data } = await axiosConfig.delete(baseURL, { params: sendData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Bulk check deleatbility
export const isDeletable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/deletable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
