import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'
import { postAxiosRequest } from '@/support/apiRequestHelpers'

const baseURL = '/fifo-layers'

export const fetchFifoLayers = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getFifoLayerById = async (id) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/${id}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getFifoLayerTransactions = async (fifoLayerId) => {
  try {
    const { data } = await axiosConfig.get(`${baseURL}/${fifoLayerId}/inventory-movements`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const recalculateFifoLayer = async (data) => postAxiosRequest(`${baseURL}/recalculate-total-costs`, data)

export const archiveFifoLayerByID = async (id) => {
  const url = `${baseURL}/${id}/archive`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveFifoLayerByID = async (id) => {
  const url = `${baseURL}/${id}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const archiveFifoLayers = async (sendData) => {
  const url = `${baseURL}/archive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const unarchiveFifoLayers = async (sendData) => {
  const url = `${baseURL}/unarchive`

  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// check nominal codes archivablity
export const isArchivable = async (ids) => {
  try {
    const { data } = await axiosConfig.post(`${baseURL}/archivable`, { ids })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
