import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/store-email-templates'

export const getAllEmailTemplates = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const fetchEmailTemplateById = async (id) => {
  const url = `${baseURL}/${id}`
  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updateEmailTemplate = async (templateId, options) => {
  const sendData = {
    store_id: options.storeId,
    type: options.type,
    subject: options.subject,
    html_body: options.html_body,
    enabled: options.enabled,
    cc: options.cc
  }
  try {
    const { data } = await axiosConfig.put(`${baseURL}/${templateId}`, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const createEmailTemplate = async (templateId, options) => {
  const sendData = {
    store_id: options.storeId,
    type: options.type,
    subject: options.subject,
    html_body: options.html_body,
    enabled: options.enabled,
    cc: options.cc
  }
  try {
    const { data } = await axiosConfig.post(`${baseURL}`, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const previewEmailTemplate = async (sendData, sendVariables) => {
  let url = `${baseURL}/preview`
  if (sendVariables) url += '?variables=true'
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getUserTemplates = async () => {
  let url = `${baseURL}/user-templates`
  try {
    const { data } = await axiosConfig.get(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteUserTemplate = async (id) => {
  let url = `${baseURL}/${id}`
  try {
    const { data } = await axiosConfig.delete(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const sendTemplate = async (orderType, orderId, emailTemplate) => {
  let url = `${baseURL}/send`
  try {
    const { data } = await axiosConfig.post(url, {
      order_type: orderType,
      order_id: orderId,
      subject: emailTemplate.subject,
      html_body: emailTemplate.html_body,
      cc: emailTemplate.cc
    })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
