import axiosConfig from '../config/axiosConfig'

const baseURL = '/custom-fields'
const baseURLForValues = '/custom-field-values'
// const filters = { 'conjunction': 'and', 'filterSet': [{ 'id': 4, 'column': 'link_type', 'operator': '=', 'dateOption': null, 'headerValue': 'link_type', 'value': 'App\\Models\SalesOrder' }] }

export const getAllCustomFields = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const saveCustomField = async (fieldData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, fieldData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updateCustomField = async (fieldData, fieldId) => {
  try {
    const { data } = await axiosConfig.put(`${baseURL}/${fieldId}`, fieldData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteCustomField = async (fieldId) => {
  try {
    const { data } = await axiosConfig.delete(`${baseURL}/${fieldId}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getAllCustomFieldsValues = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURLForValues)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const saveCustomFieldValues = async (fieldData) => {
  try {
    const { data } = await axiosConfig.post(baseURLForValues, fieldData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const updateCustomFieldValue = async (fieldData, fieldId) => {
  try {
    const { data } = await axiosConfig.put(`${baseURLForValues}/${fieldId}`, fieldData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteCustomFieldValue = async (fieldId) => {
  try {
    const { data } = await axiosConfig.delete(`${baseURLForValues}/${fieldId}`)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
