import axiosConfig from '../config/axiosConfig'

const baseURL = '/constants'

export const getCountries = async (options) => {
  let constructedQuery = ''

  if (options) {
    constructedQuery = '?'

    if (options.limit) constructedQuery = constructedQuery.concat(`limit=${options.limit}`)
    if (options.name) constructedQuery = constructedQuery.concat(`&name=${options.name}`)
    if (options.page) constructedQuery = constructedQuery.concat(`&page=${options.page}`)
    if (options.code) constructedQuery = constructedQuery.concat(`&code=${options.code}`)
  }

  try {
    const response = await axiosConfig.get(`${baseURL}/countries${constructedQuery}`)

    return response.data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getCountriesGrouped = async () => {
  try {
    const response = await axiosConfig.get(`${baseURL}/countries-grouped`)

    return response.data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getStates = async (countryCode) => {
  try {
    const response = await axiosConfig.get(`${baseURL}/states/${countryCode}?limit=-1`)

    return response.data
  } catch (e) {
    return Promise.reject(e)
  }
}
export const fetchAddressByZip = async ({ countryCode, zip }) => {
  try {
    const response = await axiosConfig.get(`${baseURL}/get-address/${countryCode}/${zip}`)

    return response.data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getAllCurrencies = async (options) => {
  let constructedQuery = ''

  if (options) {
    constructedQuery = '?'

    if (options.limit) constructedQuery = constructedQuery.concat(`limit=${options.limit}`)
    if (options.name) constructedQuery = constructedQuery.concat(`&name=${options.name}`)
    if (options.page) constructedQuery = constructedQuery.concat(`&page=${options.page}`)
    if (options.code) constructedQuery = constructedQuery.concat(`&code=${options.code}`)
  }

  try {
    const response = await axiosConfig.get(`${baseURL}/currencies${constructedQuery}`)
    return response.data
  } catch (e) {
    return Promise.reject(e)
  }
}
