import axiosConfig from '../config/axiosConfig'

const baseUrl = '/company-profile'

export const fetchCompanyProfile = async () => {
  try {
    const { data } = await axiosConfig.get(baseUrl)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
export const updateCompanyProfile = async (profile) => {
  try {
    const { data } = await axiosConfig.put(baseUrl, profile)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
