import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/csv-templates'

// Get All Nominal Codes
export const getAllCSVTemplates = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Nominal Code
export const createNominalCode = async (nominalCodeData) => {
  try {
    const { data } = await axiosConfig.post(baseURL, { ...nominalCodeData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Update Nominal Code
export const updateNominalCode = async (nominalCodeID, nominalCodeData) => {
  const url = `${baseURL}/${nominalCodeID}`

  try {
    const { data } = await axiosConfig.put(url, { ...nominalCodeData })
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
