import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/attributes'

export const getAllAttributes = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getAttributeById = async (id) => {
  // This fetches all attributes unrestricted
  return (await axiosConfig.get(`${baseURL}/${id}`)).data.data
}

export const getAttributes = async () => {
  // This fetches all attributes unrestricted
  const { data } = await axiosConfig.get(`${baseURL}/grouped`)
  return data.data
}

// Create Attribute
export const createAttribute = async (attributeData) => {
  return axiosConfig.post(baseURL, attributeData)
}

export const updateAttribute = async (attributeId, payload) => {
  return axiosConfig.put(`${baseURL}/${attributeId}`, payload)
}

// Delete Attribute
export const deleteAttribute = async (id) => {
  const url = `${baseURL}/${id}`
  return axiosConfig.delete(url)
}

// Bulk delete Attribute
export const deleteBulkAttributes = async (payload) => {
  const url = `${baseURL}`
  return axiosConfig.delete(url, { data: payload }) // Body with delete must be passed as data in axios config
}

// Check if attribute is deletable
export const attributesDeletable = async (ids) => {
  const url = `${baseURL}/deletable`
  return (await axiosConfig.post(url, {
    ids: ids
  })).data
}

// Archive Attribute
export const archiveAttributeById = async (id) => {
  const url = `${baseURL}/${id}/archive`
  return axiosConfig.put(url)
}

// Bulk Unarchive Attribute
export const unarchiveBulkAttributes = async (payload) => {
  const url = `${baseURL}/unarchive`
  return axiosConfig.put(url, payload)
}

export const unarchiveAttributeByID = async (attributeId) => {
  const url = `${baseURL}/${attributeId}/unarchived`

  try {
    const { data } = await axiosConfig.put(url)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Bulk archive Attribute
export const archiveBulkAttributes = async (payload) => {
  const url = `${baseURL}/archive`
  return axiosConfig.put(url, payload)
}

export const previewAttributesImport = async (sendData) => {
  const url = `${baseURL}/import/preview`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const importAttributesData = async (sendData) => {
  const url = `${baseURL}/import`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
