import axiosConfig from '../config/axiosConfig'
import buildUrlParams from '@/support/buildUrlParams'

const baseURL = '/attribute-groups'

export const getAllAttributeGroups = async (options = {}) => {
  try {
    const { data } = await axiosConfig.get(baseURL, buildUrlParams(options))
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

// Create Attribute group
export const createAttributeGroup = async (payload) => {
  return axiosConfig.post(baseURL, payload)
}

export const getAttributeGroups = async () => {
  return (await axiosConfig.get(`${baseURL}/grouped`)).data.data
}

export const updateAttributeGroup = async (groupId, payload) => {
  return axiosConfig.put(`${baseURL}/${groupId}`, payload)
}

export const getAttributeChildren = async (groupId) => {
  return (await axiosConfig.get(`${baseURL}/${groupId}`)).data.data
}

// Delete Attribute Group
export const deleteAttributeGroupById = async (id) => {
  const url = `${baseURL}/${id}`
  return axiosConfig.delete(url)
}

// Bulk delete Attribute
export const deleteBulkAttributeGroups = async (payload) => {
  const url = `${baseURL}`
  return axiosConfig.delete(url, { data: payload }) // Body with delete must be passed as data in axios config
}

// Check if attribute is deletable
export const attributeGroupsDeletable = async (ids) => {
  const url = `${baseURL}/deletable`
  return (await axiosConfig.post(url, {
    ids: ids
  })).data
}

// Archive Attribute
export const archiveAttributeGroupById = async (id) => {
  const url = `${baseURL}/${id}/archive`
  return axiosConfig.put(url)
}

// Bulk Unarchive Attribute
export const unarchiveBulkAttributeGroups = async (payload) => {
  const url = `${baseURL}/unarchive`
  return axiosConfig.put(url, payload)
}

// Bulk archive Attribute
export const archiveBulkAttributeGroups = async (payload) => {
  const url = `${baseURL}/archive`
  return axiosConfig.put(url, payload)
}

export const previewAttributeGroupsImport = async (sendData) => {
  const url = `${baseURL}/import/preview`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const importAttributeGroupsData = async (sendData) => {
  const url = `${baseURL}/import`
  try {
    const { data } = await axiosConfig.post(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}
