import { postAxiosRequest, getAxiosRequest, putAxiosRequest, deleteAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'

const baseUrl = '/amazon'

const getUrl = (path = '') => (path ? `${baseUrl}/${path}` : baseUrl)

export const createAmazonIntegration = (sendData) => postAxiosRequest(getUrl(), sendData)

export const fetchAmazonIntegrationInstances = () => getAxiosRequest(getUrl())

export const fetchAmazonIntegrationInstance = (id) => getAxiosRequest(getUrl(id))

export const updateAmazonIntegration = (id, sendData) => putAxiosRequest(getUrl(id), sendData)

export const deleteAmazonIntegration = (id) => deleteAxiosRequest(getUrl(id))

export const authAmazonInstance = (instanceId) => getAxiosRequest(getUrl(`${instanceId}/get-redirect-url`))

export const fetchRemovalOrdersUnlinked = (instanceId) => getAxiosRequest(getUrl(`${instanceId}/removal-orders/unlinked`))

export const getFbaInventoryValuation = (instanceId, params) => getAxiosRequest(getUrl(`${instanceId}/fba-inventory-valuation`), buildUrlParams(params))
