import { getAxiosRequest, postAxiosRequest, putAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import { getAmazonInstanceUrl } from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `ledgers`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

const getAmazonUrl = (instanceId, path = '') => {
  return getAmazonInstanceUrl(instanceId, path)
}

export const fetchAmazonInventoryLedgers = (instanceId, params) => getAxiosRequest(getUrl(instanceId), buildUrlParams(params))

export const fetchAmazonInventoryLedger = (instanceId, id) => getAxiosRequest(getUrl(instanceId, id))

export const fetchAmazonInventoryLedgerCustomerReturns = ({ instanceId }, params) => getAxiosRequest(getUrl(`${instanceId}`, 'customer-returns'), buildUrlParams(params))

export const fetchAmazonInventoryLedgerCustomerReturn = (instanceId, returnId) => getAxiosRequest(getUrl(`${instanceId}`, `customer-returns/${returnId}`))

export const fetchAmazonInventoryLedgerShipments = ({ instanceId }, params) => getAxiosRequest(getUrl(`${instanceId}`, 'shipments'), buildUrlParams(params))

export const fetchAmazonInventoryLedgerShipment = (instanceId, shipmentId) => getAxiosRequest(getUrl(`${instanceId}`, `shipments/${shipmentId}`))

export const fetchAmazonInventoryLedgerRemovalShipments = ({ instanceId }, params) => getAxiosRequest(getUrl(`${instanceId}`, 'removal-shipments'), buildUrlParams(params))

export const fetchAmazonInventoryLedgerRemovalShipment = (instanceId, removalShipmentId) => getAxiosRequest(getUrl(`${instanceId}`, `removal-shipments/${removalShipmentId}`))

export const fetchAmazonInventoryLedgerUnmatchedDetail = ({ instanceId, id }) => getAxiosRequest(getUrl(`${instanceId}`, `${id}/unmatched-detail`))

export const fetchAmazonUnmatchedLedgers = (instanceId, params) => getAxiosRequest(getUrl(instanceId, 'unmatched-ledgers'), { params: params })

export const unreconcileLedger = (instanceId, ledgerId) => postAxiosRequest(getUrl(instanceId, `${ledgerId}/unreconcile`))
export const unreconcileLedgers = (instanceId, params) => postAxiosRequest(getUrl(instanceId, `unreconcile-ledgers`), params)
export const reconcileLedger = (instanceId, ledgerId) => postAxiosRequest(getUrl(instanceId, `${ledgerId}/reconcile`))
export const reconcileLedgers = (instanceId, params) => postAxiosRequest(getUrl(instanceId, `reconcile-ledgers`), params)

export const fetchAmazonInventoryLedgerReconciliationReport = (instanceId, params) => getAxiosRequest(getUrl(instanceId, `reconciliation-report`), buildUrlParams(params))

export const linkToDetailReports = (instanceId, ledgerId, data) => postAxiosRequest(getUrl(instanceId, `${ledgerId}/link-to-detail-reports`), data)

export const reconcileAll = (instanceId) => postAxiosRequest(getUrl(instanceId, `reconcile-all`))
export const reconcileFnskuLedgers = (instanceId, fnskuProductId) => postAxiosRequest(getUrl(instanceId, `fnsku/${fnskuProductId}/reconcile`))
export const unreconcileAll = (instanceId) => postAxiosRequest(getUrl(instanceId, `unreconcile-all`))
export const unreconcileFnskuLedgers = (instanceId, fnskuProductId) => postAxiosRequest(getUrl(instanceId, `fnsku/${fnskuProductId}/unreconcile`))

export const createInventoryAdjustmentFromLedger = (intanceId, ledgerId, data) => postAxiosRequest(getUrl(intanceId, `${ledgerId}/create-inventory-adjustment`), data)
