import { getAxiosRequest, postAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import { getAmazonInstanceUrl } from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `ledger-summaries`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

export const fetchAmazonInventoryLedgerSummaries = (instanceId, params) => getAxiosRequest(getUrl(instanceId), buildUrlParams(params))

export const fetchAmazonInventoryLedgerSummary = (instanceId, id) => getAxiosRequest(getUrl(instanceId, id))

export const reconcileLedgerSummary = (instanceId, id) => postAxiosRequest(getUrl(instanceId, `${id}/reconcile`))

export const unreconcileLedgerSummary = (instanceId, id) => postAxiosRequest(getUrl(instanceId, `${id}/unreconcile`))

export const reconcileAll = (instanceId) => postAxiosRequest(getUrl(instanceId, `reconcile-all`))

export const unreconcileAll = (instanceId) => postAxiosRequest(getUrl(instanceId, `unreconcile-all`))
