import { getAxiosRequest, postAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import { getAmazonInstanceUrl } from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `initial-inventory`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}
export const fetchAmazonFbaInitialInventory = (instanceId, fnskuProductId) => getAxiosRequest(getUrl(instanceId, `${fnskuProductId}`))
export const fetchAmazonFbaInitialInventories = (instanceId, params) => getAxiosRequest(getUrl(instanceId), buildUrlParams(params))
export const reconcileAll = (instanceId) => postAxiosRequest(getUrl(instanceId, `reconcile-all`))
export const reconcile = (instanceId, initialInventoryId) => postAxiosRequest(getUrl(instanceId, `${initialInventoryId}/reconcile`))
export const unreconcile = (instanceId, initialInventoryId) => postAxiosRequest(getUrl(instanceId, `${initialInventoryId}/unreconcile`))
export const unreconcileAll = (instanceId, initialInventoryId) => postAxiosRequest(getUrl(instanceId, `unreconcile-all`))
export const reconcileInitialInventories = (instanceId, data) => postAxiosRequest(getUrl(instanceId, `reconcile`), data)
export const unreconcileInitialInventories = (instanceId, data) => postAxiosRequest(getUrl(instanceId, `unreconcile`), data)
export const reconcileInitialInventoriesForFnskus = (instanceId, data) => postAxiosRequest(getUrl(instanceId, `reconcile-for-fnskus`), data)
export const unreconcileInitialInventoriesForFnskus = (instanceId, data) => postAxiosRequest(getUrl(instanceId, `unreconcile-for-fnskus`), data)
