import { postAxiosRequest, getAxiosRequest, putAxiosRequest, deleteAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import { getAmazonInstanceUrl } from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `inbound/shipments`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

const getInboundUrl = (instanceId, path = '') => {
  const baseUrl = `inbound`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

export const deleteAmazonInboundShipment = (instanceId, id) => deleteAxiosRequest(getUrl(instanceId, `${id}`))

export const createAmazonInboundShipment = (instanceId, params) => postAxiosRequest(getUrl(instanceId), params)

export const updateAmazonInboundShipment = (instanceId, id, params) => putAxiosRequest(getUrl(instanceId, `${id}`), params)

export const fetchAmazonInboundShipmentById = (instanceId, id, params) => getAxiosRequest(getUrl(instanceId, `${id}`), { params })

export const fetchAmazonInboundShipments = (instanceId, params) => getAxiosRequest(getUrl(instanceId), buildUrlParams(params))

// labels
export const fetchAmazonInboundShipmentsLabels = (instanceId, id) => getAxiosRequest(getUrl(instanceId, `${id}/get-labels`))

// bill of lading
export const fetchAmazonInboundShipmentsBillLading = (instanceId, id) => getAxiosRequest(getUrl(instanceId, `${id}/get-bill-of-lading`))

// warehouse transfer
export const createAmazonWarehouseTransfer = (instanceId, id, sendData) => postAxiosRequest(getUrl(instanceId, `${id}/create-warehouse-transfer`), sendData)

export const fetchUnlinkedAmazonInboundShipments = (instanceId, params = null) => getAxiosRequest(getUrl(instanceId, 'unlinked'), { params })

export const fetchAmazonShipFromMappings = (instanceId, params = null) => getAxiosRequest(getInboundUrl(instanceId, 'ship-from-mappings'), { params })

export const updateAmazonShipFromMappings = (instanceId, params) => postAxiosRequest(getInboundUrl(instanceId, `ship-from-mappings`), params)

export const refresh = (instanceId) => postAxiosRequest(getUrl(instanceId, `refresh`))
export const processAll = (instanceId) => postAxiosRequest(getInboundUrl(instanceId, `process-all`))
export const process = (instanceId, params) => postAxiosRequest(getInboundUrl(instanceId, `process`), params)
export const unprocess = (instanceId, params) => postAxiosRequest(getInboundUrl(instanceId, `unprocess`), params)

export const setSentBeforeInitialCount = (instanceId, params) => postAxiosRequest(getUrl(instanceId, `set-sent-before-initial-count`), params)
