import { getAxiosRequest, postAxiosRequest } from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import { getAmazonInstanceUrl } from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `fnsku-products`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}
export const fetchAmazonFnskuProduct = (instanceId, fnskuProductId) => getAxiosRequest(getUrl(instanceId, `${fnskuProductId}`))
export const fetchAmazonFnskuProducts = (instanceId, params) => getAxiosRequest(getUrl(instanceId), buildUrlParams(params))
export const createAmazonFnskuProducts = (instanceId) => postAxiosRequest(getUrl(instanceId, 'create'))
export const linkAmazonFnskuToProduct = (instanceId, data) => postAxiosRequest(getUrl(instanceId, 'link-to-product'), data)
