import {getAxiosRequest, putAxiosRequest} from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import {getAmazonInstanceUrl} from '@/support/amazonApiHelpers'
import { postAxiosRequest } from '../support/apiRequestHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `finances`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

export const fetchFinancesEventGroupById = (instanceId, groupId) => getAxiosRequest(getUrl(instanceId,`event-groups/${groupId}`))

export const fetchFinancesEventGroups = (instanceId, params) => getAxiosRequest(getUrl(instanceId,'event-groups'), buildUrlParams(params))

export const fetchFinancesSettlementData = (instanceId, params) => getAxiosRequest(getUrl(instanceId,'settlement-data'), buildUrlParams(params))

export const fetchFinancesSettlementTypeMappings = (instanceId) => getAxiosRequest(getUrl(instanceId,'settlement-data/type-mappings'))

export const updateFinancesSettlementTypeMappings = (instanceId, sendData) => putAxiosRequest(getUrl(instanceId,'settlement-data/type-mappings'), sendData)

export const createAccountingTransaction = (instanceId, sendData) => postAxiosRequest(getUrl(instanceId, 'event-groups/create-accounting-transactions'), sendData)

export const exportFinancesSettlementTypeMappings = (instanceId) => {
  window.open('/api' + getUrl(instanceId, 'settlement-data/type-mappings/export'))
}
export const importFinancesSettlementTypeMappings = (instanceId, sendData) => postAxiosRequest(getUrl(instanceId, 'settlement-data/type-mappings/import'), sendData)
