import {getAxiosRequest} from '@/support/apiRequestHelpers'
import buildUrlParams from '@/support/buildUrlParams'
import {getAmazonInstanceUrl} from '@/support/amazonApiHelpers'

const getUrl = (instanceId, path = '') => {
  const baseUrl = `fba-inventory`
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getAmazonInstanceUrl(instanceId, pathName)
}

export const fetchFbaInventory = (instanceId, params) => getAxiosRequest(getUrl(instanceId), buildUrlParams(params))

export const fetchFbaInventoryById = (instanceId, id) => getAxiosRequest(getUrl(instanceId,`${id}`))
