import { getChildren, getMeta } from '@/routes/routerHelpers'

const VeracoreHome = () => import('@/views/Integrations/veracore/VeracoreHome')
const InitialSetup = () => import('@/views/Integrations/veracore/InitialSetup')
const Dashboard = () => import('@/views/Integrations/veracore/Dashboard')
const Connections = () => import('@/views/Integrations/veracore/Connections')
const Settings = () => import('@/views/Integrations/veracore/Settings')

const INTEGRATION_NAME = 'Veracore'
const INTEGRATION_PATH_NAME = 'veracore'

const getPath = (segments, withInstanceId = true, isInitial = false) => {
  let prefix = isInitial ? '/integrations' : `/integrations/${INTEGRATION_PATH_NAME}`
  if (withInstanceId) prefix += '/:instanceId'
  return `${prefix}/${segments}`
}
const getRouteName = (name = '') => `${INTEGRATION_NAME} ${name}`

const childrenList = [
  { name: 'Dashboard', path: 'dashboard', component: Dashboard, },
  { name: 'Settings', path: 'settings', component: Settings, },
  { name: 'Connection', path: 'connection', component: Connections, },
]

export const veracoreIntegrationRoutes = (() => {
  return [
    {
      path: getPath(`initial-setup-${INTEGRATION_PATH_NAME}`, false, true),
      name: getRouteName('Initial Setup'),
      component: InitialSetup,
      meta: {
        requiresWizardDone: false,
        customBreadcrumbBefore: {
          text: INTEGRATION_NAME,
          disabled: true
        }
      }
    },
    {
      path: `/integrations/${INTEGRATION_PATH_NAME}/:instanceId`,
      name: getRouteName(),
      component: VeracoreHome,
      meta: {
        requiresWizardDone: false,
        breadcrumbLinkDisable: true,
        customBreadcrumbAfter: {
          type: 'integrations'
        }
      },
      children: getChildren(childrenList, getPath, getRouteName, getMeta)
    },
  ]
})()
