import { getChildren, getMeta } from '@/routes/routerHelpers'
// Shipstation
const IntegrationsShipstation = () => import('@/views/Integrations/shipstation/IntegrationsShipstation')
const IntegrationsShipstationInitialSetup = () => import('@/views/Integrations/shipstation/IntegrationsShipstationInitialSetup')
const IntegrationsShipstationDashboard = () => import('@/views/Integrations/shipstation/IntegrationsShipstationDashboard')
const IntegrationsShipstationFulfillment = () => import('@/views/Integrations/shipstation/IntegrationsShipstationFulfillment')
const IntegrationsShipstationShipping = () => import('@/views/Integrations/shipstation/IntegrationsShipstationShipping')
const IntegrationsShipstationConnections = () => import('@/views/Integrations/shipstation/IntegrationsShipstationConnections')
const IntegrationsShipstationSettings = () => import('@/views/Integrations/shipstation/IntegrationsShipstationSettings')
const IntegrationsShipstationWarehouseMappings = () => import('@/views/Integrations/shipstation/IntegrationsShipstationWarehouseMappings')
// const IntegrationsShipstationActionsLog = () => import('@/views/Integrations/shipstation/IntegrationsShipstationActionsLog')
// const IntegrationsShipstationErrorsLog = () => import('@/views/Integrations/shipstation/IntegrationsShipstationErrorsLog')
const INTEGRATION_NAME = 'ShipStation'
const getPath = (segments, withInstanceId = true, isInitial = false) => {
  let prefix = isInitial ? '/integrations' : '/integrations/shipstation'
  if (withInstanceId) prefix += '/:instanceId'
  return `${prefix}/${segments}`
}
const getRouteName = (name = '') => `${INTEGRATION_NAME} ${name}`
const childrenList = [
  { name: 'Dashboard', path: 'dashboard', component: IntegrationsShipstationDashboard, },
  { name: 'Fulfillment', path: 'fulfillment', component: IntegrationsShipstationFulfillment, },
  { name: 'Shipping', path: 'shipping', component: IntegrationsShipstationShipping, },
  { name: 'Connection', path: 'connection', component: IntegrationsShipstationConnections, },
  { name: 'Settings', path: 'settings', component: IntegrationsShipstationSettings, },
  { name: 'Warehouse Mappings', path: 'warehouse-mappings', component: IntegrationsShipstationWarehouseMappings, },
  // { name: 'Actions Log', path: 'actions-log', component: IntegrationsShipstationActionsLog, },
  // { name: 'Errors Log', path: 'errors-log', component: IntegrationsShipstationErrorsLog, },
]
export const shipstationRoutes = (() => {
  return [
    {
      path: getPath('initial-setup-shipstation', false, true),
      name: getRouteName('Initial Setup'),
      component: IntegrationsShipstationInitialSetup,
      meta: {
        requiresWizardDone: false,
        customBreadcrumbBefore: {
          text: INTEGRATION_NAME,
          disabled: true
        }
      }
    },
    {
      path: '/integrations/shipstation/:instanceId',
      name: getRouteName(),
      component: IntegrationsShipstation,
      meta: {
        requiresWizardDone: false,
        breadcrumbLinkDisable: true,
        customBreadcrumbAfter: {
          type: 'integrations'
        }
      },
      children: getChildren(childrenList, getPath, getRouteName, getMeta)
    },
  ]
})()
