import {getChildren, getMeta} from '@/routes/routerHelpers'

const SettingsView = () => import('@/views/Settings/SettingsView')
const NominalCodes = () => import('@/views/Settings/accounting/NominalCodes')
const PaymentTerms = () => import('@/views/Settings/PaymentTerms')
const SettingsStores = () => import('@/views/Settings/SettingsStores')
const SettingsTags = () => import('@/views/Settings/SettingsTags')
const SettingsCurrencies = () => import('@/views/Settings/SettingsCurrencies')
const CSVTemplates = () => import('@/views/Settings/CSVTemplates')
const SettingsForecasting = () => import('@/views/Settings/SettingsForecasting')
const SettingsInventoryStartDate = () => import('@/views/Settings/SettingsInventoryStartDate')
const SettingsWarehouses = () => import('@/views/Settings/SettingsWarehouses')
const SettingsAttributes = () => import('@/views/Settings/SettingsAttributes')
const AttributeGroups = () => import('@/views/Settings/AttributeGroups')
const SettingsBrands = () => import('@/views/Settings/SettingsBrands')
const SettingsCategories = () => import('@/views/Settings/SettingsCategories')
const PricingTiers = () => import('@/views/Settings/PricingTiers')
const SettingsIncoterms = () => import('@/views/Settings/SettingsIncoterms')
const SupplierPricingTiers = () => import('@/views/Settings/SupplierPricingTiers')
const SalesOrders = () => import('@/views/Settings/SalesOrders')
const SettingsPurchaseOrders = () => import('@/views/Settings/SettingsPurchaseOrders')
const SettingsPurchaseOrdersBuilder = () => import('@/views/Settings/SettingsPurchaseOrdersBuilder')
const SettingsReturnReasons = () => import('@/views/Settings/SettingsReturnReasons')
const SettingsPaymentTypes = () => import('@/views/Settings/SettingsPaymentTypes')
const ShippingMethods = () => import('@/views/Settings/ShippingMethods')
const SettingsAutoFulfillments = () => import('@/views/Settings/SettingsAutoFulfillments')
const SettingsEmailTemplates = () => import('@/views/Settings/SettingsEmailTemplates')
const SettingsDateTime = () => import('@/views/Settings/SettingsDateTime')
const SettingsWarehouseTransfers = () => import('@/views/Settings/SettingsWarehouseTransfers')
const SettingsBarcodes = () => import('@/views/Settings/SettingsBarcodes')
const SettingsUnitsOfMeasurement = () => import('@/views/Settings/SettingsUnitsOfMeasurement')
const SettingsDataFeeds = () => import('@/views/Settings/SettingsDataFeeds')
const SettingsSalesCredits = () => import('@/views/Settings/SettingsSalesCredits')
const SettingsTaxRates = () => import('@/views/Settings/accounting/SettingsTaxRates')
const SettingsAccounting = () => import('@/views/Settings/accounting/SettingsAccounting')
const SettingsFinancialTypes = () => import('@/views/Settings/SettingsFinancialTypes')
const SettingsFinancialAlerts = () => import('@/views/Settings/SettingsFinancialAlerts')
const SettingsBackgroundJobLogs = () => import('@/views/Settings/SettingsBackgroundJobLogs')
const SettingsBlemishedSkuPattern = () => import('@/views/Settings/SettingsBlemishedSkuPattern')
const SettingsUsers = () => import('@/views/Settings/SettingsUsers')
const SettingsAdvancedShipmentNotices = () => import('@/views/Settings/SettingsAdvancedShipmentNotices')

const getPath = (segments = '') => `/settings/${segments}`
const getRouteName = (name) => name
const getBreadcrumbBefore = (text) => ({customBreadcrumbBefore: {text, disabled: true}})

const childrenList = [
  {
    name: 'Settings Nominal Codes',
    path: 'nominal-codes',
    component: NominalCodes,
    meta: {...getMeta(), ...getBreadcrumbBefore('Accounting')}
  },
  {
    name: 'Settings Payment Terms',
    path: 'payment-terms',
    component: PaymentTerms,
    meta: {...getMeta(), ...getBreadcrumbBefore('Accounting')}
  },
  {
    name: 'Tax Rates',
    path: 'tax-rates',
    component: SettingsTaxRates,
    meta: {...getMeta(), ...getBreadcrumbBefore('Accounting')}
  },
  {
    name: 'Settings Stores',
    path: 'stores',
    component: SettingsStores,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings Tags',
    path: 'tags',
    component: SettingsTags,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings Currencies',
    path: 'currencies',
    component: SettingsCurrencies,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings CSV Templates',
    path: 'csv-templates',
    component: CSVTemplates,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings Auto Fulfillments',
    path: 'auto-fulfillments',
    component: SettingsAutoFulfillments,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings Shipping Methods',
    path: 'shipping-methods',
    component: ShippingMethods,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings Sales Orders',
    path: 'sales-orders',
    component: SalesOrders,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings Return Reasons',
    path: 'return-reasons',
    component: SettingsReturnReasons,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings Payment Types',
    path: 'payment-types',
    component: SettingsPaymentTypes,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings Warehouses',
    path: 'warehouses',
    component: SettingsWarehouses,
    meta: {...getMeta(), ...getBreadcrumbBefore('Inventory')}
  },
  {
    name: 'Settings Warehouse Transfers',
    path: 'warehouse-transfers',
    component: SettingsWarehouseTransfers,
    meta: {...getMeta(), ...getBreadcrumbBefore('Inventory')}
  },
  {
    name: 'Settings Forecasting',
    path: 'forecasting',
    component: SettingsForecasting,
    meta: {...getMeta(), ...getBreadcrumbBefore('Inventory')}
  },
  {
    name: 'Settings Inventory Start Date',
    path: 'inventory-start-date',
    component: SettingsInventoryStartDate,
    meta: {...getMeta(), ...getBreadcrumbBefore('Inventory')}
  },
  {
    name: 'Settings Attributes',
    path: 'attributes',
    component: SettingsAttributes,
    meta: {...getMeta(), ...getBreadcrumbBefore('Products')}
  },
  {
    name: 'Settings Attribute Groups',
    path: 'attribute-groups',
    component: AttributeGroups,
    meta: {...getMeta(), ...getBreadcrumbBefore('Products')}
  },
  {
    name: 'Settings Brands',
    path: 'brands',
    component: SettingsBrands,
    meta: {...getMeta(), ...getBreadcrumbBefore('Products')}
  },
  {
    name: 'Settings Categories',
    path: 'categories',
    component: SettingsCategories,
    meta: {...getMeta(), ...getBreadcrumbBefore('Products')}
  },
  {
    name: 'Settings Pricing Tiers',
    path: 'pricing-tiers',
    component: PricingTiers,
    meta: {...getMeta(), ...getBreadcrumbBefore('Products')}
  },
  {
    name: 'Settings Barcodes',
    path: 'barcodes',
    component: SettingsBarcodes,
    meta: {...getMeta(), ...getBreadcrumbBefore('Products')}
  },
  {
    name: 'Units Of Measurement',
    path: 'units-of-measurement',
    component: SettingsUnitsOfMeasurement,
    meta: {...getMeta(), ...getBreadcrumbBefore('Products')}
  },
  {
    name: 'Settings Incoterms',
    path: 'incoterms',
    component: SettingsIncoterms,
    meta: {...getMeta(), ...getBreadcrumbBefore('Purchasing')}
  },
  {
    name: 'Settings Purchase Orders',
    path: 'purchase-orders',
    component: SettingsPurchaseOrders,
    meta: {...getMeta(), ...getBreadcrumbBefore('Purchasing')}
  },
  {
    name: 'Settings Purchase Orders Builder',
    path: 'purchase-orders-builder',
    component: SettingsPurchaseOrdersBuilder,
    meta: {...getMeta(), ...getBreadcrumbBefore('Purchasing')}
  },
  {
    name: 'Settings Supplier Pricing Tiers',
    path: 'supplier-pricing-tiers',
    component: SupplierPricingTiers,
    meta: {...getMeta(), ...getBreadcrumbBefore('Purchasing')}
  },
  {
    name: 'Settings Email Templates',
    path: 'email-templates',
    component: SettingsEmailTemplates,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings Date & Time',
    path: 'date-time',
    component: SettingsDateTime,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings Sales Credits',
    path: 'sales-credits',
    component: SettingsSalesCredits,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Settings Data Feeds',
    path: 'data-feeds',
    component: SettingsDataFeeds,
    meta: {...getMeta(), ...getBreadcrumbBefore('Data Feeds')}
  },
  {
    name: 'General',
    path: 'accounting-general',
    component: SettingsAccounting,
    meta: {...getMeta(), ...getBreadcrumbBefore('Accounting')}
  },
  {
    name: 'Settings Financial Types',
    path: 'financial-types',
    component: SettingsFinancialTypes,
    meta: {...getMeta(), ...getBreadcrumbBefore('Financial Types')}
  },
  {
    name: 'Settings Financial Alerts',
    path: 'financial-alerts',
    component: SettingsFinancialAlerts,
    meta: {...getMeta(), ...getBreadcrumbBefore('Financial Alerts')}
  },
  {
    name: 'Background Jobs Log',
    path: 'background-jobs-log',
    component: SettingsBackgroundJobLogs,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'Blemished Products',
    path: 'blemished-products',
    component: SettingsBlemishedSkuPattern,
    meta: {...getMeta(), ...getBreadcrumbBefore('Products')}
  },
  {
    name: 'Users',
    path: 'users',
    component: SettingsUsers,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  },
  {
    name: 'AdvancedShipmentNotices',
    path: 'advanced-shipment-notices',
    component: SettingsAdvancedShipmentNotices,
    meta: {...getMeta(), ...getBreadcrumbBefore('General')}
  }
]

export const settingsRoutes = (() => {
  return [
    {
      path: getPath(),
      name: 'Settings',
      component: SettingsView,
      meta: {
        requiresWizardDone: false,
        requiresPowerUser: true
      },
      children: getChildren(childrenList, getPath, getRouteName, getMeta)
    }
  ]
})()
