import { getChildren, getMeta } from '@/routes/routerHelpers'

const ReportsView = () => import('@/views/Reports/ReportsView')
const SalesOrderLinesFinancials = () => import('@/views/Reports/SalesOrderLinesFinancials')
const ReportsFinancialAlerts = () => import('@/views/Reports/ReportsFinancialAlerts')
const ReportsIncomeStatement = () => import('@/views/Reports/ReportsIncomeStatement')
const ReportShipBySchedule = () => import('@/views/Reports/ReportShipBySchedule')
const FinancialSummaries = () => import('@/views/Reports/FinancialSummaries')
const DailyFinancialSummary = () => import('@/views/Reports/DailyFinancialSummary')
const InventoryValuation = () => import('@/views/Reports/ReportsInventoryValuation')
const ReportUncoveredBlemishedProducts = () => import('@/views/Reports/ReportUncoveredBlemishedProducts')
const ReportListedBlemishedProductsOutOfStock = () => import('@/views/Reports/ReportListedBlemishedProductsOutOfStock')
const ReportSalesChannelCoverage = () => import('@/views/Reports/ReportSalesChannelCoverage')

const getPath = (segments = '') => `/reports/${segments}`
const getRouteName = (name) => name

const childrenList = [
  // commented due to SKU-6202
  // { name: 'Report Templates', path: 'report-templates', component: ReportsTemplates, },
  // { name: 'Generated Reports', path: 'generated-reports', component: GeneratedReports, },
  { name: 'Financial Alerts', path: 'financial-alerts', component: ReportsFinancialAlerts, },
  { name: 'Income Statement', path: 'reports-income-statement', component: ReportsIncomeStatement, },
  { name: 'Ship By Schedule', path: 'ship-by-schedule', component: ReportShipBySchedule, },
  { name: 'Financial Summaries', path: 'financial-summaries', component: FinancialSummaries, },
  { name: 'Sales Order Financials', path: 'sales-order-financials', component: SalesOrderLinesFinancials, },
  { name: 'Daily Financial Summary', path: 'daily-financial-summary', component: DailyFinancialSummary, },
  { name: 'Inventory Valuation', path: 'inventory-valuation', component: InventoryValuation, },
  { name: 'Sales Channel Coverage', path: 'sales-channel-coverage', component: ReportSalesChannelCoverage, },
  { name: 'Uncovered Blemished Products', path: 'uncovered-blemished-products', component: ReportUncoveredBlemishedProducts, },
  { name: 'Listed Blemished Products Out-of-stock', path: 'listed-blemished-products-out-of-stock', component: ReportListedBlemishedProductsOutOfStock, },
]

export const reportsRoutes = (() => {
  return [
    {
      path: getPath(),
      name: 'Reports',
      component: ReportsView,
      meta: {
        requiresWizardDone: false,
        requiresPowerUser: true,
      },
      children: getChildren(childrenList, getPath, getRouteName, getMeta)
    },
  ]
})()
