// Shopify
const IntegrationsShopify = () => import('@/views/Integrations/shopify/IntegrationsShopify')
const IntegrationsShopifyInitialSetup = () => import('@/views/Integrations/shopify/IntegrationsShopifyInitialSetup')
const IntegrationsShopifyDashboard = () => import('@/views/Integrations/shopify/IntegrationsShopifyDashboard')
const IntegrationsShopifyOrderSettings = () => import('@/views/Integrations/shopify/IntegrationsShopifyOrderSettings')
const IntegrationsShopifyOrders = () => import('@/views/Integrations/shopify/IntegrationsShopifyOrders')
const IntegrationsShopifyListings = () => import('@/views/Integrations/shopify/IntegrationsShopifyListings')
const IntegrationsShopifyPricing = () => import('@/views/Integrations/shopify/IntegrationsShopifyPricing')
const IntegrationsShopifyInventory = () => import('@/views/Integrations/shopify/IntegrationsShopifyInventory')
const IntegrationsShopifySettings = () => import('@/views/Integrations/shopify/IntegrationsShopifySettings')
const IntegrationsShopifyConnection = () => import('@/views/Integrations/shopify/IntegrationsShopifyConnection')
const IntegrationsShopifyShipping = () => import('@/views/Integrations/shopify/IntegrationsShopifyShipping')
const IntegrationsShopifyActionsLog = () => import('@/views/Integrations/shopify/IntegrationsShopifyActionsLog')
const IntegrationsShopifyErrorsLog = () => import('@/views/Integrations/shopify/IntegrationsShopifyErrorsLog')
const IntegrationsShopifyAutoCreate = () => import('@/views/Integrations/shopify/IntegrationsShopifyAutoCreate')

export const shopifyRoutes = (() => {
  return [
    // Shopify
    {
      path: '/integrations/initial-setup-shopify',
      name: 'Shopify Initial Setup',
      component: IntegrationsShopifyInitialSetup,
      meta: {
        requiresWizardDone: false
      }
    },
    {
      path: '/integrations/shopify/:instanceId',
      name: 'Shopify',
      component: IntegrationsShopify,
      meta: {
        requiresWizardDone: false,
        breadcrumbLinkDisable: true,
        customBreadcrumbAfter: {
          type: 'integrations'
        }
      },
      children: [
        {
          path: '/integrations/shopify/:instanceId/dashboard',
          name: 'Shopify Dashboard',
          component: IntegrationsShopifyDashboard,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/shopify/:instanceId/orders-settings',
          name: 'Shopify Orders Settings',
          component: IntegrationsShopifyOrderSettings,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/shopify/:instanceId/orders',
          name: 'Shopify Pending Orders',
          component: IntegrationsShopifyOrders,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/shopify/:instanceId/mapping',
          name: 'Shopify Mapping',
          component: IntegrationsShopifyListings,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/shopify/:instanceId/pricing',
          name: 'Shopify Pricing',
          component: IntegrationsShopifyPricing,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/shopify/:instanceId/inventory',
          name: 'Shopify Inventory',
          component: IntegrationsShopifyInventory,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/shopify/:instanceId/settings',
          name: 'Shopify Settings',
          component: IntegrationsShopifySettings,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/shopify/:instanceId/auto-create',
          name: 'Shopify Auto Create',
          component: IntegrationsShopifyAutoCreate,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/shopify/:instanceId/connection',
          name: 'Shopify Connection',
          component: IntegrationsShopifyConnection,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/shopify/:instanceId/shipping',
          name: 'Shopify Shipping',
          component: IntegrationsShopifyShipping,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/shopify/:instanceId/actions-log',
          name: 'Shopify Actions Log',
          component: IntegrationsShopifyActionsLog,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/shopify/:instanceId/errors-log',
          name: 'Shopify Errors Log',
          component: IntegrationsShopifyErrorsLog,
          meta: {
            requiresWizardDone: false
          }
        }
      ]
    },
  ]
})()
