// Xero
const IntegrationsXero = () => import('@/views/Integrations/xero/IntegrationsXero')
const IntegrationsXeroInitialSetup = () => import('@/views/Integrations/xero/IntegrationsXeroInitialSetup')
const IntegrationsXeroDashboard = () => import('@/views/Integrations/xero/IntegrationsXeroDashboard')
const IntegrationsXeroPaymentMethodsMapping = () => import('@/views/Integrations/xero/IntegrationsXeroPaymentMethodsMapping')
const IntegrationsXeroSettings = () => import('@/views/Integrations/xero/IntegrationsXeroSettings')
const IntegrationsXeroConnection = () => import('@/views/Integrations/xero/IntegrationsXeroConnection')
const IntegrationsXeroConsolidation = () => import('@/views/Integrations/xero/IntegrationsXeroConsolidation')
const IntegrationsXeroTaxRates = () => import('@/views/Integrations/xero/IntegrationsXeroTaxRates')
const IntegrationsXeroSuppliersCustomers = () => import('@/views/Integrations/xero/IntegrationsXeroSuppliersCustomers')
const IntegrationsXeroFinalizeOAuth = () => import('@/views/Integrations/xero/IntegrationsXeroFinalizeOAuth')
const IntegrationsXeroErrorsLog = () => import('@/views/Integrations/xero/IntegrationsXeroErrorsLog')
// const IntegrationsXeroPayments = () => import('@/views/Integrations/xero/IntegrationsXeroPayments')
const IntegrationsXeroAccounts = () => import('@/views/Integrations/xero/IntegrationsXeroAccounts')

export const xeroRoutes = (() => {
  return [
    // Xero
    {
      path: '/integrations/initial-setup-xero',
      name: 'Xero Initial Setup',
      component: IntegrationsXeroInitialSetup,
      meta: {
        requiresWizardDone: false,
        customBreadcrumbBefore: {
          text: 'Xero',
          disabled: true
        }
      }
    },
    {
      path: '/integrations/xero/:instanceId',
      name: 'Xero',
      component: IntegrationsXero,
      meta: {
        requiresWizardDone: false,
        breadcrumbLinkDisable: true,
        customBreadcrumbAfter: {
          type: 'integrations'
        }
      },
      children: [
        {
          path: '/integrations/xero/:instanceId/dashboard',
          name: 'Xero Dashboard',
          component: IntegrationsXeroDashboard,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/xero/:instanceId/consolidation',
          name: 'Xero Consolidation',
          component: IntegrationsXeroConsolidation,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/xero/:instanceId/tax-rates',
          name: 'Xero Tax Rate Mappings',
          component: IntegrationsXeroTaxRates,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/xero/:instanceId/contacts',
          name: 'Xero Contacts',
          component: IntegrationsXeroSuppliersCustomers,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/xero/:instanceId/errors-log',
          name: 'Xero Errors Log',
          component: IntegrationsXeroErrorsLog,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/xero/:instanceId/connection',
          name: 'Xero Connection',
          component: IntegrationsXeroConnection,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/xero/:instanceId/settings',
          name: 'Xero Settings',
          component: IntegrationsXeroSettings,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/xero/:instanceId/payment-methods-mapping',
          name: 'Xero Payment Methods Mapping',
          component: IntegrationsXeroPaymentMethodsMapping,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/xero/:instanceId/finalize',
          name: 'Xero Finalize',
          component: IntegrationsXeroFinalizeOAuth,
          meta: {
            requiresWizardDone: false
          }
        },
        {
          path: '/integrations/xero/:instanceId/accounts',
          name: 'Xero Payments',
          component: IntegrationsXeroAccounts,
          meta: {
            requiresWizardDone: false
          }
        }
      ]
    }
  ]
})()
