import { getChildren, getMeta } from "@/routes/routerHelpers";

const IntegrationsAmazon = () => import('@/views/Integrations/amazon/IntegrationsAmazon')
const IntegrationsAmazonInitialSetup = () => import('@/views/Integrations/amazon/IntegrationsAmazonInitialSetup')
const IntegrationsAmazonListings = () => import('@/views/Integrations/amazon/IntegrationsAmazonListings')
const IntegrationsAmazonOrdersSettings = () => import('@/views/Integrations/amazon/IntegrationsAmazonOrdersSettings')
const IntegrationsAmazonInboundShipments = () => import('@/views/Integrations/amazon/IntegrationsAmazonInboundShipments')
const IntegrationsAmazonNewInboundShipments = () => import('@/views/Integrations/amazon/IntegrationsAmazonNewInboundShipments')
const IntegrationsAmazonShipFromMappings = () => import('@/views/Integrations/amazon/IntegrationsAmazonShipFromMappings')
const IntegrationsAmazonSettings = () => import('@/views/Integrations/amazon/IntegrationsAmazonSettings')
const IntegrationsAmazonAutoCreate = () => import('@/views/Integrations/amazon/IntegrationsAmazonAutoCreate')
const IntegrationsAmazonConnections = () => import('@/views/Integrations/amazon/IntegrationsAmazonConnections')
const IntegrationsAmazonDashboard = () => import('@/views/Integrations/amazon/IntegrationsAmazonDashboard')
const IntegrationsAmazonPricing = () => import('@/views/Integrations/amazon/IntegrationsAmazonPricing')
const IntegrationsAmazonOrders = () => import('@/views/Integrations/amazon/IntegrationsAmazonOrders')
const IntegrationsAmazonShipping = () => import('@/views/Integrations/amazon/IntegrationsAmazonShipping')
const IntegrationsAmazonInventory = () => import('@/views/Integrations/amazon/IntegrationsAmazonInventory')
const IntegrationsAmazonFnskuProducts = () => import('@/views/Integrations/amazon/IntegrationsAmazonFnskuProducts')
const IntegrationsAmazonFinalize = () => import('@/views/Integrations/amazon/IntegrationsAmazonFinalize')
const IntegrationsAmazonFba = () => import('@/views/Integrations/amazon/IntegrationsAmazonFba')
const IntegrationsAmazonInventoryLedger = () => import('@/views/Integrations/amazon/IntegrationsAmazonInventoryLedger')
const IntegrationsAmazonInventoryLedgerSummaries = () => import('@/views/Integrations/amazon/IntegrationsAmazonInventoryLedgerSummaries')
const IntegrationsAmazonInventoryLedgerSummaryAdjustments = () => import('@/views/Integrations/amazon/IntegrationsAmazonInventoryLedgerSummaryAdjustments')
const IntegrationsAmazonLedgerReconciliationReport = () => import('@/views/Integrations/amazon/IntegrationsAmazonLedgerReconciliationReport')
const IntegrationsAmazonFbaInventoryValuation = () => import('@/views/Integrations/amazon/IntegrationsAmazonFbaInventoryValuation')
const IntegrationsAmazonFinancialEventGroups = () => import('@/views/Integrations/amazon/IntegrationsAmazonFinancialEventGroups')
const IntegrationsAmazonFbaInventory = () => import('@/views/Integrations/amazon/IntegrationsAmazonFbaInventory')
const IntegrationsAmazonAccountingMappings = () => import('@/views/Integrations/amazon/IntegrationsAmazonAccountingMappings')
const IntegrationsAmazonRemovalShipmentsDetail = () => import('@/views/Integrations/amazon/detail-reports/IntegrationsAmazonRemovalShipmentsDetail')
const IntegrationsAmazonRemovalOrdersDetail = () => import('@/views/Integrations/amazon/detail-reports/IntegrationsAmazonRemovalOrdersDetail')
const IntegrationsAmazonShipmentsDetail = () => import('@/views/Integrations/amazon/detail-reports/IntegrationsAmazonShipmentsDetail')
const IntegrationsAmazonCustomerReturns = () => import('@/views/Integrations/amazon/detail-reports/IntegrationsAmazonCustomerReturns')
const IntegrationsAmazonRestockReport = () => import('@/views/Integrations/amazon/IntegrationsAmazonRestockReport')
const IntegrationsAmazonInboundSettings = () => import('@/views/Integrations/amazon/IntegrationsAmazonInboundSettings')

const INTEGRATION_NAME = "Amazon US";
const INTEGRATION_PATH_NAME = "amazon-us";

const getPath = (segments, withInstanceId = true, isInitial = false) => {
  let prefix = isInitial ? "/integrations" : `/integrations/${INTEGRATION_PATH_NAME}`;
  if (withInstanceId) prefix += "/:instanceId";
  return `${prefix}/${segments}`;
};
const getRouteName = (name = "") => `${INTEGRATION_NAME} ${name}`;

const childrenList = [
  { name: 'Dashboard', path: 'dashboard', component: IntegrationsAmazonDashboard, },
  { name: 'Mapping', path: 'mapping', component: IntegrationsAmazonListings, },
  { name: 'Orders Settings', path: 'orders-settings', component: IntegrationsAmazonOrdersSettings, },
  { name: 'Inbound Shipments', path: 'inbound-shipments', component: IntegrationsAmazonInboundShipments, },
  { name: 'New Inbound Shipments', path: 'new-inbound-shipments', component: IntegrationsAmazonNewInboundShipments, },
  { name: 'Ship From Mappings', path: 'ship-from-mappings', component: IntegrationsAmazonShipFromMappings, },
  { name: 'Orders', path: 'orders', component: IntegrationsAmazonOrders, },
  { name: 'Settings', path: 'settings', component: IntegrationsAmazonSettings, },
  { name: 'Auto Create', path: 'auto-create', component: IntegrationsAmazonAutoCreate, },
  { name: 'Connection', path: 'connection', component: IntegrationsAmazonConnections, },
  { name: 'Pricing', path: 'pricing', component: IntegrationsAmazonPricing, },
  { name: 'Shipping', path: 'shipping', component: IntegrationsAmazonShipping, },
  { name: 'Inventory', path: 'inventory', component: IntegrationsAmazonInventory, },
  { name: 'FBA (FNSKU) Products', path: 'fnsku-products', component: IntegrationsAmazonFnskuProducts, },
  { name: 'Finalize', path: 'finalize', component: IntegrationsAmazonFinalize, },
  { name: 'FBA', path: 'fba', component: IntegrationsAmazonFba, },
  { name: 'Inventory Ledger', path: 'inventory-ledger', component: IntegrationsAmazonInventoryLedger, },
  { name: 'Ledger Summaries', path: 'ledger-summaries', component: IntegrationsAmazonInventoryLedgerSummaries, },
  { name: 'Ledger Summary Adjustments', path: 'ledger-summary-adjustments', component: IntegrationsAmazonInventoryLedgerSummaryAdjustments, },
  { name: 'Ledger Reconciliation Report', path: 'ledger-reconciliation-report', component: IntegrationsAmazonLedgerReconciliationReport, },
  { name: 'FBA Inventory Valuation', path: 'fba-inventory-valuation', component: IntegrationsAmazonFbaInventoryValuation, },
  { name: 'Financial Event Groups', path: 'financial-event-groups', component: IntegrationsAmazonFinancialEventGroups, },
  { name: 'FBA Inventory', path: 'fba-inventory', component: IntegrationsAmazonFbaInventory, },
  { name: 'Accounting Mappings', path: 'accounting-mappings', component: IntegrationsAmazonAccountingMappings, },
  { name: 'Customer Returns', path: 'customer-returns', component: IntegrationsAmazonCustomerReturns, },
  { name: 'Shipments Detail', path: 'shipments-detail', component: IntegrationsAmazonShipmentsDetail, },
  { name: 'Removal Shipments Detail', path: 'removal-shipments-detail', component: IntegrationsAmazonRemovalShipmentsDetail, },
  { name: 'Removal Orders', path: 'removal-orders', component: IntegrationsAmazonRemovalOrdersDetail, },
  { name: 'Restock Report', path: 'restock-report', component: IntegrationsAmazonRestockReport, },
  { name: 'Inbound Settings', path: 'inbound-settings', component: IntegrationsAmazonInboundSettings, },
]

export const amazonIntegrationsRoutes = (() => {
  return [
    {
      path: getPath(`initial-setup-${INTEGRATION_PATH_NAME}`, false, true),
      name: getRouteName("Initial Setup"),
      component: IntegrationsAmazonInitialSetup,
      meta: {
        requiresWizardDone: false,
        customBreadcrumbBefore: {
          text: INTEGRATION_NAME,
          disabled: true,
        },
      },
    },
    {
      path: `/integrations/${INTEGRATION_PATH_NAME}/:instanceId`,
      name: getRouteName(),
      component: IntegrationsAmazon,
      meta: {
        requiresWizardDone: false,
        breadcrumbLinkDisable: true,
        customBreadcrumbAfter: {
          type: "integrations",
        },
      },
      children: getChildren(childrenList, getPath, getRouteName, getMeta),
    },
  ];
})();
