import Vue from 'vue'
import Router from 'vue-router'
import store from './store/store'
import {localStorageService} from './support/localStorage'
import {redirectToLogin} from '@/services/AuthService'
// import routes
import {ebayRoutes} from '@/routes/ebayIntegrationsRoutes'
// import routes

import { reportsRoutes } from '@/routes/reportsRoutes'
import { amazonIntegrationsRoutes } from '@/routes/amazonIntegrationsRoutes'
import { wooCommerceRoutes } from '@/routes/wooCommerceIntegrationsRoutes'
import { settingsRoutes } from '@/routes/settingsRoutes'
import { shipMyOrdersIntegrationsRoutes } from '@/routes/shipMyOrdersIntegrationsRoutes'
import { shipstationRoutes } from '@/routes/shipstationRoutes'
import { veracoreIntegrationRoutes } from '@/routes/veracoreIntegrationRoutes'
import { xeroRoutes } from '@/routes/integrations/accounting/xeroRoutes'
import { magentoRoutes } from '@/routes/integrations/magentoRoutes'
import { starshipitRoutes } from '@/routes/integrations/shipping-providers/starshipitRoutes'
import { shopifyRoutes } from '@/routes/integrations/sales-channels/shopifyRoutes'
import { quickBooksRoutes } from '@/routes/integrations/accounting/quickBooksRoutes'
import AccountSetupView from "@/views/Auth/AccountSetupView.vue";

// Components
const DashboardView = () => import('@/views/DashboardView')
const GettingStartedView = () => import('@/views/GettingStartedView')

// Products Pages
const ProductsView = () => import('@/views/Products/ProductsView')

// Orders Pages
const OrdersView = () => import('@/views/Orders/OrdersView')
const PurchaseOrdersView = () => import('@/views/PurchaseOrders/PurchaseOrdersView')
const FulfillmentsView = () => import('@/views/Fulfillments/FulfillmentsView')

// Inventory Pages
const InventoryView = () => import('@/views/Inventory/InventoryView')
const InventoryAdjustmentsView = () => import('@/views/Inventory/InventoryAdjustmentsView')
const BackorderQueueView = () => import('@/views/Inventory/BackorderQueueView')
const InventoryAuditTrailView = () => import('@/views/Inventory/InventoryAuditTrailView')
const InventoryForecastingView = () => import('@/views/Inventory/InventoryForecastingView')
const InventoryFifoLayersView = () => import('@/views/Inventory/InventoryFifoLayersView')
const InventoryPurchaseCreditsView = () => import('@/views/Inventory/InventoryPurchaseCreditsView')
const InventorySalesCreditsView = () => import('@/views/Inventory/InventorySalesCreditsView')
const InventoryWarehouseTransfersView = () => import('@/views/Inventory/InventoryWarehouseTransfersView')
const InventoryAssembliesView = () => import('@/views/Inventory/InventoryAssembliesView')
const InventoryStockTakesView = () => import('@/views/Inventory/InventoryStockTakesView')

// Accounting Pages
const AccountingView = () => import('@/views/Accounting/AccountingView')
const AccountingPaymentsView = () => import('@/views/Accounting/AccountingPaymentsView')
const AccountingTransactionsView = () => import('@/views/Accounting/AccountingTransactionsView')

// Integrations pages
const IntegrationsView = () => import('@/views/Integrations/IntegrationsView')

const SandboxView = () => import('@/views/SandboxView')

const CRMView = () => import('@/views/CRM/CRMView')
const CRMWarehousesView = () => import('@/views/CRM/CRMWarehousesView')
const CRMCustomersView = () => import('@/views/CRM/CRMCustomersView')
const CRMSuppliersView = () => import('@/views/CRM/CRMSuppliersView')

const EbayAccepted = () => import('@/views/SalesChannelsOAuthAccepted/EbayAuthAccepted')
const ShopifyAccepted = () => import('@/views/SalesChannelsOAuthAccepted/ShopifyAuthAccepted')
const GoogleExpressAccepted = () => import('@/views/SalesChannelsOAuthAccepted/GoogleExpressAuthAccepted')

const DBSchema = () => import('@/views/DBSchema/DBSchemaView')

const Statuses = () => import('@/views/Statuses')
const TheLoginForm = () => import('@/components/globals/TheLoginForm')

const UserProfileView = () => import('@/views/UserProfile/UserProfileView')

const CompanyProfileView = () => import('@/views/CompanyProfile/CompanyProfileView')

// Helpers

const URLReadableValueEncoder = function (string) {
  /*    '%' => '%25'    '+' => '%2B'
         ' ' => '+'      '&' => '%26'    */
  let encoded = string
  encoded = encoded.replace(/\%/g, '%25')
  encoded = encoded.replace(/\&/g, '%26')
  encoded = encoded.replace(/\+/g, '%2B')
  encoded = encoded.replace(/ /g, '+')
  return encoded
}

Vue.use(Router)

const router = new Router({
  stringifyQuery (queryObject) {
    var str = []
    for (var p in queryObject) {
      if (queryObject.hasOwnProperty(p)) {
        str.push(encodeURIComponent(p) + '=' + URLReadableValueEncoder(queryObject[p]))
      }
    }

    let query = str.join('&')

    return query ? ('?' + query) : ''
  },
  mode: 'history',
  // scrollBehavior: function(to, from, savedPosition) {
  //   if (to.hash) {
  //     return {selector: to.hash}
  //   } else {
  //     return { x: 0, y: 0 }
  //   }
  // },
  base: process.env.BASE_URL,
  routes: [
    {
      path: '/statuses',
      name: 'status',
      component: Statuses
    },
    {
      path: '/sandbox',
      name: 'sandbox',
      component: SandboxView,
      meta: {
        layout: 'sandbox'
      }
    },
    {
      path: '/',
      name: 'Home',
      redirect: '/dashboard'
    },
    {
      path: '/login',
      name: 'Login',
      component: TheLoginForm,
      meta: { requiresWizardDone: false, allowGuestUser: true, layout: 'login' }
    },
    // {
    //   path: '/settings',
    //   name: 'DashboardExampleView',
    //   component: SettingsView,
    //   meta: { requiresWizardDone: true, requiresAdmin: true }
    // },
    {
      path: '/dashboard',
      name: 'Dashboard',
      component: DashboardView,
      meta: { requiresWizardDone: true }
    },
    {
      path: '/orders',
      name: 'Sales Orders',
      component: OrdersView,
      meta: { requiresWizardDone: false }
    },
    {
      path: '/fulfillments',
      name: 'Fulfillments',
      component: FulfillmentsView,
      meta: { requiresWizardDone: false }
    },
    {
      path: '/purchase-orders',
      name: 'Purchase Orders',
      component: PurchaseOrdersView,
      meta: { requiresWizardDone: false }
    },
    {
      path: '/products/:query?',
      name: 'Products',
      component: ProductsView,
      // mode: 'history',
      meta: { requiresWizardDone: false }
    },
    // inventory pages
    {
      path: '/inventory',
      name: 'Inventory',
      component: InventoryView,
      meta: { requiresWizardDone: false },
      children: [
        {
          path: '/inventory/backorder-queue',
          name: 'Inventory Backorder Queue',
          component: BackorderQueueView,
          meta: { requiresWizardDone: false }
        },
        {
          path: '/inventory/inventory-adjustments',
          name: 'Inventory Adjustments',
          component: InventoryAdjustmentsView,
          meta: { requiresWizardDone: false }
        },
        {
          path: '/inventory/stock-takes',
          name: 'Inventory Stock Takes',
          component: InventoryStockTakesView,
          meta: { requiresWizardDone: false }
        },
        {
          path: '/inventory/inventory-audit-trail',
          name: 'Inventory Audit Trail',
          component: InventoryAuditTrailView,
          meta: { requiresWizardDone: false }
        },
        {
          path: '/inventory/inventory-forecasting',
          name: 'Inventory Forecasting',
          component: InventoryForecastingView,
          meta: { requiresWizardDone: false }
        },
        {
          path: '/inventory/fifo-layers',
          name: 'Inventory FIFO Layers',
          component: InventoryFifoLayersView,
          meta: { requiresWizardDone: false }
        },
        {
          path: '/inventory/purchase-credits',
          name: 'Inventory Purchase Credits',
          component: InventoryPurchaseCreditsView,
          meta: { requiresWizardDone: false }
        },
        {
          path: '/inventory/sales-credits',
          name: 'Inventory Sales Credits',
          component: InventorySalesCreditsView,
          meta: { requiresWizardDone: false }
        },
        {
          path: '/inventory/warehouse-transfers',
          name: 'Inventory Warehouse Transfers',
          component: InventoryWarehouseTransfersView,
          meta: { requiresWizardDone: false }
        },
        {
          path: '/inventory/assemblies',
          name: 'Inventory Assemblies',
          component: InventoryAssembliesView,
          meta: { requiresWizardDone: false }
        }
      ]
    },
    // Accounting
    {
      path: '/accounting',
      name: 'Accounting',
      component: AccountingView,
      meta: { requiresWizardDone: false },
      children: [
        {
          path: '/accounting/payments',
          name: 'Payments',
          component: AccountingPaymentsView,
          meta: { requiresWizardDone: false }
        },
        {
          path: '/accounting/transactions',
          name: 'Transactions',
          component: AccountingTransactionsView,
          meta: { requiresWizardDone: false }
        }
      ]
    },
    // Reports
    ...reportsRoutes,
    // integrations pages
    {
      path: '/integrations',
      name: 'Apps & Integrations',
      component: IntegrationsView,
      meta: { requiresWizardDone: false, requiresPowerUser: true },
      children: [
        // Ebay
        ...ebayRoutes,

        // Amazon
        ...amazonIntegrationsRoutes,

        // ShipStation
        ...shipstationRoutes,

        // ShipMyOrders
        ...shipMyOrdersIntegrationsRoutes,
        // Veracore
        ...veracoreIntegrationRoutes,
        // Starshipit
        ...starshipitRoutes,
        // Shopify
        ...shopifyRoutes,
        // Xero
        ...xeroRoutes,

        // QuickBooks
        ...quickBooksRoutes,

        ...magentoRoutes,
        // WooCommerce
        ...wooCommerceRoutes
      ]
    },
    // settings pages
    ...settingsRoutes,
    {
      path: '/crm',
      name: 'CRM',
      component: CRMView,
      meta: {
        requiresWizardDone: false,
        requiresPowerUser: true
      },
      children: [
        {
          path: 'warehouses',
          name: 'CRM Warehouses',
          component: CRMWarehousesView,
          meta: { requiresWizardDone: false }
        },
        {
          path: 'customers',
          name: 'CRM Customers',
          component: CRMCustomersView,
          meta: { requiresWizardDone: false }
        },
        {
          path: 'suppliers',
          name: 'CRM Suppliers',
          component: CRMSuppliersView,
          meta: { requiresWizardDone: false }
        }
      ]
    },
    {
      path: '/getting-started',
      name: 'Getting Started',
      component: GettingStartedView
    },
    {
      path: '/ebay-auth-accepted',
      name: 'Ebay Auth Accepted',
      component: EbayAccepted
    },
    {
      path: '/shopify-auth-accepted',
      name: 'Shopify Auth Accepted',
      component: ShopifyAccepted
    },
    {
      path: '/google-express-auth-accepted',
      name: 'Google Express Auth Accepted',
      component: GoogleExpressAccepted
    },
    {
      path: '/db/:version?',
      name: 'DBSchema',
      component: DBSchema
    },
    // profiles
    {
      path: '/company-profile',
      name: 'Company Profile',
      component: CompanyProfileView,
      meta: { requiresWizardDone: false }
    },
    {
      path: '/user-profile',
      name: 'User Profile',
      component: UserProfileView
    },
    {
      path: '*',
      name: 'Redirect',
      redirect: '/dashboard'
    },
    {
      path: '/setup-account/:token',
      name: 'Account Setup',
      component: AccountSetupView,
      meta: { requiresWizardDone: false, allowGuestUser: true, layout: 'login' }
    }
  ]
})

// Global Route Guards
router.beforeEach((to, from, next) => {
  // Get instance of layer manager (drawer manager)
  // and decide whether to open or close a drawer/modal based on current URL.

  if (!localStorageService.getToken() && to.name !== 'Login') redirectToLogin()

  Vue.prototype.$layerManager.updateLayers(to.query, from.query)

  // Check if wizard is already completed
  const isWizardDone = true // store.getters['WizardModule/isWizardDone']
  const isAdmin = store.getters['UsersModule/getIsAdmin']
  const isPowerUser = store.getters['UsersModule/getIsPowerUser']

  if (to.matched.some(record => record.meta.requiresWizardDone)) {
    if (!isWizardDone) {
      next({
        path: '/getting-started'
      })
    } else {
      if (to.matched.some(record => record.meta.requiresAdmin)) {
        if (!isAdmin || !isPowerUser) {
          next({
            path: '/'
          })
        } else {
          next()
        }
      }
      next()
    }
  } else {
    if (to.matched.some(record => record.meta.requiresPowerUser)) {
      if (!isPowerUser) {
        next({
          path: '/'
          // query: { redirect: to.fullPath }
        })
      } else {
        next()
      }
    }

    if (isWizardDone && to.path === '/getting-started') {
      next('/dashboard')
    } else {
      next()
    }
  }
})

export default router
