export default {
  methods: {
    setMenuPosition ({ ctxMenuData, menu, table }) {
      const tableCoordinates = table.getBoundingClientRect()

      const fromTableLeftToClick = ctxMenuData.coordinates.x - tableCoordinates.left
      const fromTableTopToClick = ctxMenuData.coordinates.y - tableCoordinates.top

      const ctxLeft = fromTableLeftToClick + table.scrollLeft
      const ctxTop = fromTableTopToClick + table.scrollTop

      // check if the menu is not too far to the right/bottom, because we don't want to create aditional space
      const toFarToTheRight = Boolean(table.scrollWidth - (fromTableLeftToClick + table.scrollLeft) < menu.$el.offsetWidth)
      const toFarToTheBottom = Boolean(table.scrollHeight - (fromTableTopToClick + table.scrollTop) < menu.$el.offsetHeight)

      if (toFarToTheRight && toFarToTheBottom) {
        menu.$el.style.left = `${table.scrollWidth - menu.$el.offsetWidth}px`
        menu.$el.style.top = `${table.scrollHeight - menu.$el.offsetHeight}px`
      } else if (toFarToTheRight) {
        menu.$el.style.left = `${table.scrollWidth - menu.$el.offsetWidth}px`
        menu.$el.style.top = `${ctxTop}px`
      } else if (toFarToTheBottom) {
        menu.$el.style.left = `${ctxLeft}px`
        menu.$el.style.top = `${table.scrollHeight - menu.$el.offsetHeight}px`
      } else {
        // else set menu position on mouse click coordinates
        menu.$el.style.left = `${ctxLeft}px`
        menu.$el.style.top = `${ctxTop}px`
      }
    },
  },
}
