import EventBus from '../SKUTableEventBus'

export default {
  data () {
    return {
      dragElement: null,
      dragRow: null
    }
  },
  mounted () {
    document.body.addEventListener('mousemove', this.mouseMove)
    document.body.addEventListener('mouseup', this.handleMouseUpGeneral)
  },
  beforeDestroy () {
    document.body.removeEventListener('mousemove', this.mouseMove)
    document.body.removeEventListener('mouseup', this.handleMouseUpGeneral)
  },
  methods: {
    startRowDrag (e, row) {
      if (this.dragElement) return

      this.dragElement = document.createElement('div')
      this.dragElement.innerText = this.getSelectedRowsObjects && this.getSelectedRowsObjects.length > 1 ? `Reorder ${this.getSelectedRowsObjects.length} rows` : 'Reorder 1 row'
      this.dragElement.ondragstart = () => false
      this.dragElement.className = 'drag-element'
      this.dragElement.style.zIndex = '999999999999'
      this.dragElement.style.cursor = 'pointer'
      this.dragElement.style.position = 'absolute'
      this.dragElement.style.left = e.x + 1 + 'px'
      this.dragElement.style.top = e.y + 1 + 'px'

      document.body.appendChild(this.dragElement)

      this.dragRow = row
    },

    mouseMove (e) {
      if (this.dragElement) {
        this.dragElement.style.left = e.x + 1 + 'px'
        this.dragElement.style.top = e.y + 1 + 'px'
      }
    },

    handleMouseUpElement (e, row) {
      if (this.dragElement) {
        if (this.getSelectedRowsObjects && this.getSelectedRowsObjects.length) {
          EventBus.$emit(this.storeNamespace + '--reorderRowByDrag', { selectedRowsIds: this.getSelectedRowsObjects.map(i => i.id), targetRow: row })
        } else {
          EventBus.$emit(this.storeNamespace + '--reorderRowByDrag', { selectedRowsIds: [this.dragRow.id], targetRow: row })
        }
      }
    },

    handleMouseUpGeneral (e, row) {
      if (this.dragElement) {
        document.body.removeChild(this.dragElement)
        this.dragElement = null
        this.dragRow = null
      }
    }
  }
}
