// Default View

export const defaultView = {
  id: -1,
  name: 'sku.io view',
  value: 'default',
  content: {
    filters: {
      conjunction: 'and',
      filterSet: []
    },
    sort: [],
    density: 'compact',
    showArchivedItems: false,
    query: ''
  }
}

export const stringOptions = [
  {
    id: 1,
    value: '=',
    name: 'is'
  },
  {
    id: 2,
    value: '!=',
    name: 'is not'
  },
  {
    id: 3,
    value: 'isEmpty',
    name: 'is empty',
    hideInput: true
  },
  {
    id: 4,
    value: 'isNotEmpty',
    name: 'is not empty',
    hideInput: true
  },
  {
    id: 5,
    value: 'startsWith',
    name: 'starts with'
  },
  {
    id: 6,
    value: 'endsWith',
    name: 'ends with'
  },
  {
    id: 7,
    value: 'contains',
    name: 'contains'
  },
  {
    id: 8,
    value: 'doesNotContain',
    name: 'does not contain'
  },
  {
    id: 9,
    value: 'isAnyOf',
    name: 'is one of'
  }
]

export const stringExtendedOptions = [
  ...stringOptions,
  {
    id: 10,
    value: 'isAssigned',
    name: 'is assigned',
    hideInput: true
  },
  {
    id: 11,
    value: 'isNotAssigned',
    name: 'is not assigned',
    hideInput: true
  }
]

export const numberOptions = [
  {
    id: 10,
    value: '=',
    name: '='
  },
  {
    id: 11,
    value: '!=',
    name: '≠'
  },
  {
    id: 12,
    value: '<',
    name: '<'
  },
  {
    id: 13,
    value: '>',
    name: '>'
  },
  {
    id: 14,
    value: '<=',
    name: '≤'
  },
  {
    id: 15,
    value: '>=',
    name: '≥'
  },
  {
    id: 16,
    value: 'isEmpty',
    name: 'is empty',
    hideInput: true
  },
  {
    id: 17,
    value: 'isNotEmpty',
    name: 'is not empty',
    hideInput: true
  },
  {
    id: 18,
    value: 'isAnyOf',
    name: 'is one of'
  }
]

export const dateOptions = [
  {
    id: 19,
    value: '=',
    name: 'is'
  },
  {
    id: 20,
    value: '<',
    name: 'is before'
  },
  {
    id: 21,
    value: '>',
    name: 'is after'
  },
  {
    id: 22,
    value: '<=',
    name: 'is on or before'
  },
  {
    id: 23,
    value: '>=',
    name: 'is on or after'
  },
  {
    id: 24,
    value: '!=',
    name: 'is not'
  },
  {
    id: 25,
    value: 'isWithin',
    name: 'is within'
  },
  {
    id: 26,
    value: 'isNotEmpty',
    name: 'is set'
  },
  {
    id: 27,
    value: 'isEmpty',
    name: 'is not set'
  }
]

export const fulfillableOptions = [
  {
    id: 28,
    value: 'all',
    name: 'All items'
  },
  {
    id: 29,
    value: 'some',
    name: 'Some items'
  },
  {
    id: 30,
    value: 'none',
    name: 'No items'
  }
]

// make sure that dateFilterOptions and dateFilterWithinOptions have unique values
export const dateFilterOptions = [
  {
    value: 'exactDate',
    name: 'exact date...',
    hasDatePicker: true
  },
  {
    value: 'tomorrow',
    name: 'tomorrow'
  },
  {
    value: 'today',
    name: 'today'
  },
  {
    value: 'yesterday',
    name: 'yesterday'
  },
  {
    value: 'oneWeekAgo',
    name: 'one week ago'
  },
  {
    value: 'oneWeekFromNow',
    name: 'one week from now'
  },
  {
    value: 'daysAgo',
    name: 'number of days ago...',
    hasInput: true
  },
  {
    value: 'daysFromNow',
    name: 'number of days from now...',
    hasInput: true
  }
]
export const dateFilterWithinOptions = [
  {
    value: 'nextNumberOfDays',
    name: 'the next number of days...',
    hasInput: true
  },
  {
    value: 'range',
    name: 'the range',
    hasDatePicker: true,
    hasRange: true
  },
  {
    value: 'pastWeek',
    name: 'the past week'
  },
  {
    value: 'pastYear',
    name: 'the past year'
  },
  {
    value: 'nextWeek',
    name: 'the next week'
  },
  {
    value: 'nextMonth',
    name: 'the next month'
  },
  {
    value: 'nextYear',
    name: 'the next year'
  },
  {
    value: 'pastNumberOfDays',
    name: 'the past number of days...',
    hasInput: true
  },
  {
    value: 'pastNumberOfMinutes',
    name: 'the past number of minutes...',
    hasInput: true
  }
]

export const fulfillableSecondaryOptions = [
  {
    id: 1,
    value: 'all',
    name: 'All',
    all: true,
    some: true,
    none: true
  },
  {
    id: 2,
    value: 'yes',
    name: 'Was backordered',
    some: true,
    all: true
  },
  {
    id: 3,
    value: 'no',
    name: 'Was not backordered',
    some: true,
    all: true
  },
  {
    id: 4,
    value: 'released_by_po',
    name: 'Backorder released by PO',
    some: true,
    all: true,
    hasInput: true
  },
  {
    id: 5,
    value: 'awaiting_receipts',
    name: 'Awaiting receipt',
    none: true
  },
  {
    id: 6,
    value: 'needs_sourcing',
    name: 'Needs Sourcing',
    none: true
  },
  {
    id: 7,
    value: 'sourcing_scheduled',
    name: 'Sourcing Scheduled',
    none: true
  }
]

export const backorderedOptions = [
  {
    id: 31,
    value: 'yes',
    name: 'Was backordered',
    some: true,
    all: true
  },
  {
    id: 32,
    value: 'no',
    name: 'Was not backordered',
    some: true,
    all: true
  },
  {
    id: 33,
    value: 'released_by_po',
    name: 'Backorder released by PO',
    some: true,
    all: true,
    hasInput: true
  },
]

export const dropdownOptions = [
  {
    id: 34,
    value: '=',
    name: 'is'
  },
  {
    id: 35,
    value: '!=',
    name: 'is not'
  },
  {
    id: 36,
    value: 'isEmpty',
    name: 'is empty',
    hideInput: true
  },
  {
    id: 37,
    value: 'isNotEmpty',
    name: 'is not empty',
    hideInput: true
  },
]

// Filter Options
export const filterOptions = (type) => {
  let options
  switch (type) {
    case 'string':
      options = stringOptions
      break
    case 'string-extended':
      options = stringExtendedOptions
      break
    case 'number':
      options = numberOptions
      break
    case 'boolean':
      options = [{
        id: 18,
        value: '=',
        name: 'mock filter option'
      }]
      break
    case 'date':
      options = dateOptions
      break
    case 'fulfillableOptions':
      options = fulfillableOptions
      break
    case 'backorderedOptions':
      options = backorderedOptions
      break
    case 'dropdown':
    case 'stringSelect':
      options = dropdownOptions
      break
  }

  return options
}
