import SKUGlobalCLI from './SKUGlobalCLI.vue'
import { debounce } from 'lodash'

export default {
  install (Vue, store) {
    // Register module when installing the plugin
    store.registerModule('SKUGlobalCLIModule', SKUGlobalCLIModule)

    // Register the Global search component globally
    Vue.component('SKUGlobalCLI', SKUGlobalCLI)

    // Registering Global CLI Directive
    Vue.directive('global-search', {
      bind: (el) => {
        // Debouncer
        el.addEventListener('input', debounce(e => e, 500))

        // Disable Global CLI on Focus
        el.addEventListener('focus', () => {
          store.dispatch('SKUGlobalCLIModule/setCanGlobalCLI', false)
        })

        // Enable Global CLI on Blur
        el.addEventListener('blur', () => {
          store.dispatch('SKUGlobalCLIModule/setCanGlobalCLI', true)
        })
      }
    })

    // Add openGlobalCLI to the Vue prototype
    Vue.prototype.$openGlobalCLI = (options) => {
      store.dispatch('SKUGlobalCLIModule/openGlobalCLI', options)
    }
    // Add closeGlobalCLI to the Vue prototype
    Vue.prototype.$closeGlobalCLI = (options) => {
      store.dispatch('SKUGlobalCLIModule/closeGlobalCLI', options)
    }
  }
}

const SKUGlobalCLIModule = {
  namespaced: true,
  state: {
    visible: false,
    canGlobalCLI: true
  },
  getters: {
    isVisible: state => state.visible,
    canGlobalCLI: state => state.canGlobalCLI
  },
  mutations: {
    // Open global search dialog mutation
    OPEN_GLOBAL_CLI (state, options) {
      state.visible = true
    },
    // Close global search dialog mutation
    CLOSE_GLOBAL_CLI (state, options) {
      state.visible = false
    },
    // Make the global search available mutation
    SET_CAN_GLOBAL_CLI (state, value) {
      state.canGlobalCLI = value
    }
  },
  actions: {
    // Open global search action
    openGlobalCLI ({ commit }, options) {
      commit('OPEN_GLOBAL_CLI', options)
    },
    // Close global search action
    closeGlobalCLI ({ commit }, options) {
      commit('CLOSE_GLOBAL_CLI', options)
    },
    // Make the global search available action
    setCanGlobalCLI ({ commit }, value) {
      commit('SET_CAN_GLOBAL_CLI', value)
    }
  }
}
