
export default {
  methods: {
    /**
     * Iteratively touches fields separated by dots
     * for validation
     * @param field
     */
    touch (field) {
      const parts = field.split('.')
      let target = this.$v
      parts.forEach(part => {
        target = target[part]
      })
      target.$touch()
    },

    validationFailed () {
      this.$v.$touch()
      return this.$v.$invalid
    }
  }
}
