export default {
  methods: {
    toggleGlobalCheckbox () {
      if (this.getDrawerMode === 'view') return

      this.globalCheckbox = !this.globalCheckbox
      this.items.forEach(i => {
        i.selected = this.globalCheckbox
      })
      this.items = JSON.parse(JSON.stringify(this.items))
    },
    toggleItem (item, index) {
      if (this.getDrawerMode === 'view') return
      let newItem = JSON.parse(JSON.stringify(item))
      newItem.selected = !item.selected
      const entityIndex = this.items.findIndex(entity => entity.id === item.id)

      if (entityIndex !== -1) this.$set(this.items, entityIndex, newItem)
      else this.$set(this.items, index, newItem)

      this.checkGlobalCheckbox()
    },
    checkGlobalCheckbox () {
      // check if all selected and set true
      this.globalCheckbox = this.items.filter(i => i.selected).length === this.items.length;
    },
    onClickItem ($event, item) {
      const index = this.items.findIndex(({id}) => id === item.id )
      const newItem = JSON.parse(JSON.stringify(item))
      newItem.selected = $event
      this.$set(this.items, index, newItem)
      this.checkGlobalCheckbox()
    },
    onClickAllItems ($event) {
      const items = this.items.map(item => {
        item.selected = $event
        return item
      })
      this.globalCheckbox = $event
      this.$set(this, 'items', items)
    }
  }
}
