import { mapGetters, mapActions } from 'vuex'

export default ({
  viewStoreModuleName,
  tableStoreModuleName,
  viewStoreGetters = [],
  tableStoreGetters = [],
  viewStoreActions = []
}) => {
  return {
    computed: {
      ...mapGetters(viewStoreModuleName, [
        ...(new Set([
          'getMeta',
          'getLoading',
          'getMaxPages',
          'getItemsList',
          'getTableSpecifications',
          ...viewStoreGetters,
        ]))
      ]),
      ...mapGetters(tableStoreModuleName, [
        ...(new Set([
          'getPageLimit',
          'getTableHeaders',
          'getVisibleHeaders',
          'getFilteringCriteria',
          'getSelectedRows',
          'getSelectedAllRows',
          'getSelectedRowsObjects',
          ...tableStoreGetters,
        ]))
      ])
    },
    methods: {
      ...mapActions(viewStoreModuleName, [
        ...(new Set([
          'getMetaRequest',
          'getItemsRequest',
          'loadTableSpecifications',
          ...viewStoreActions,
        ]))
      ]),
    }
  }
}
