import { mapGetters } from 'vuex'

export default ({
  contextName = () => (console.log('context not provided for tableLookupMixin')),
} = {}) => {
  return {
    data () {
      return {
        // lookup
        lookupOptions: [],
        lookupPage: 1,
      }
    },
    computed: {
      ...mapGetters('EnumsModule', ['getEnumText']),
    },
    methods: {
      async filterLookup ({ value, header, bottomScroll }) {
        this.lookupPage = bottomScroll ? this.lookupPage + 1 : 0
        try {
          const {data} = await this.fetchLookupValues({value,header,page:this.lookupPage,limit:this.getPageLimit})
  
          let options = data.reduce((acc,option) => {
            if (option) {
              const transformed = this.getEnumText({ context: contextName, variableName: header.value, dataName: option })
              acc = transformed ? [...acc, { value: transformed, name: transformed }] : acc
            }
            return acc
          },[])

          options = this.prepareLookupOptions({options,header})
  
          this.lookupOptions = bottomScroll ? [...this.lookupOptions, ...options] : options
        } catch (e) {
  
        }
      },
      prepareLookupOptions ({options}) {
        return options
      },
    },
  }
}