import { fetch3PLAndDirectWarehouses } from '@/services/WarehousesService'
import showErrors from '@/support/showErrors'

export default {

  data () {
    return {
      linked_warehouse: null,
      loadingWarehouses: false,
      directAnd3PLWarehouses: []
    }
  },

  computed: {
    linkedWarehouseErrors () {
      const errors = []
      if (!this.$v.linked_warehouse.$dirty) return errors

      !this.$v.linked_warehouse.required && errors.push('Warehouse is required')
      this.$emit('error', errors.length !== 0)

      return errors
    }
  },

  async created () {
    await this.loadWarehouses()
  },

  methods: {
    selectLinkedWarehouse(warehouse) {
      this.linked_warehouse = warehouse
    },
    async loadWarehouses () {
      this.loadingWarehouses = true
      try {
        this.directAnd3PLWarehouses = await fetch3PLAndDirectWarehouses()
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.loadingWarehouses = false
      }
    }
  }

}
