import {fetchPurchaseOrderLine} from '@/services/orders/PurchaseOrdersService'
import {preparePOLines,} from '@/support/productItems'
import showErrors from '@/support/showErrors'

export default {
  methods: {
    async fetchPurchaseOrderLines (orderId,loadingPropName = null,isSetLoader = false) {
      if (isSetLoader) this.$set(this, loadingPropName, true)
      try {
        const {data} = await fetchPurchaseOrderLine(orderId,{limit:-1})
        if (!data) return
        return preparePOLines(data)
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        if (isSetLoader) this.$set(this, loadingPropName, false)
      }
    },
  },
}
