export default {
  methods: {
    lineHasNegativeAdjustments(row, type) {
      const selectedItem = this.getSelectedItem
      if (!selectedItem || !Array.isArray(selectedItem.adjustments)) {
        return false // or 0, depending on your logic
      }
      return selectedItem.adjustments.filter(
        adjustment => adjustment.quantity < 0 && adjustment.type.link_id === row.id &&
              adjustment.type.link_type === type
      ).length
    },
    getNegativeAdjustmentsQty (row, type) {
      if (!this.getSelectedItem || !Array.isArray(this.getSelectedItem.adjustments)) {
        return 0
      }

      return this.getSelectedItem.adjustments.filter(
        adjustment => adjustment.quantity < 0 && adjustment.type.link_id === row.id &&
              adjustment.type.link_type === type
      ).reduce((acc, adjustment) => acc + adjustment.quantity, 0)
    }
  }
}
