import { mapGetters } from 'vuex'

export default {

  computed: {
    ...mapGetters('ConstantsModule', ['getCurrencies'])
  },

  methods: {
    currencySymbol (currencyCode) {
      if (this.getCurrencies) {
        let currency = this.getCurrencies.find(i => i.code === currencyCode)
        if (currency && currency.symbol) return currency.symbol
      }
      return ''
    },
    makeMoney (currencyCode, amount = 0, precision = 2) {
      const format = precision ? '0,0.00' : '0,0'
      return (amount < 0 ? '-' : '') + this.currencySymbol(currencyCode) + this.numeral(this.formatDigit(Math.abs(amount).toFixed(precision))).format(format)
      // {{ totalAmount < 0 ? '-' : '' }}{{ `${currencySymbol('USD')}${formatDigit(Math.abs(totalAmount))}` }}
    }
  }

}
