import { mapGetters } from 'vuex'
import { humanizeStringValue, capitalize } from '@/support/helpers'

export default {
  data () {
    return {
      lookupOptions: [],
      lookupPage: 1,
      lookupExcludeEnumHeaders: [],
    }
  },
  computed: {
    ...mapGetters('EnumsModule', ['getEnumText']),
    isSetLookupExcludes () {
      return this.lookupExcludeEnumHeaders.length !== 0
    }
  },
  methods: {
    async filterLookup ({ value, header, bottomScroll }) {
      if (bottomScroll) {
        // update same lookup search on bottom scroll
        this.lookupPage += 1
      } else {
        // new lookup search
        this.lookupPage = 1
      }

      try {
        const {data} = await this.fetchLookupValues({
          value,
          header,
          page: this.lookupPage,
          limit: this.getPageLimit
        })

        const options = data.map(item => {
          if (this.isSetLookupExcludes) return { name: humanizeStringValue(item, '_', capitalize), value: item }

          const transformed = this.getEnumText({
            context: this.enumContext,
            variableName: header.value,
            dataName: item
          })
          return { value: transformed, name: transformed }
        })

        this.lookupOptions = bottomScroll
          ? [...this.lookupOptions, ...options]
          : options
      } catch (e) {
        // console.log(e)
      }
    }
  }
}
