import { getProductInventory } from '@/services/ProductsService'
import { fetchWarehouses } from '@/services/WarehousesService'
import { mapMutations } from 'vuex'

export default {
  data () {
    return {
      stockLevelsData: [],
      loadingInventory: false,
      bundledData: [],
    }
  },
  methods: {
    ...mapMutations('InventoryAssembliesModule', [
      'SET_STOCK_DATA',
    ]),
    async fetchInventory (productID) {
      if (!productID) return

      let stockLevelsData = []
      try {
        this.loadingInventory = true
        const inventory = await getProductInventory(productID)

        if (!inventory) return
        let warehouses = Object.values(inventory.warehouses)

        if (warehouses.length === 0) {
          const {data} = await fetchWarehouses({limit:-1, included:JSON.stringify(['id', 'name'])})
          warehouses = data.map(({name,id}) => ({warehouse_id:id, warehouse_name:name}))
        }

        if (inventory.hasOwnProperty('bundle_data')) {
          let bundledData = inventory.bundle_data.reduce((acc, bundle) => {
            const warehouse = warehouses.find(w => w.warehouse_id === bundle.warehouse_id)
            const statuses = Object.keys(bundle).reduce((acc, key) => {
              if (key !== 'warehouse_id') acc = {...acc, [key]:bundle[key].max_bundle_quantity || 0}
              return acc
            }, {})
            bundle = {...bundle, ...statuses}
            if (bundle.warehouse_id === 0) bundle.warehouse_name = 'Total'
            else if(warehouse?.warehouse_name) bundle.warehouse_name = warehouse.warehouse_name
            if (bundle.warehouse_name) acc = [...acc, bundle]

            return acc
          }, [])
          const totalRow = bundledData.reduce((acc,row) => {
            if (row.warehouse_id !== 0) {
              Object.keys(acc).forEach(key => {
                if (!['warehouse_name','warehouse_id'].includes(key)) acc[key] += Number(row[key])
              })
            }
            return acc
          },{
            warehouse_id:0,
            warehouse_name: 'Total',
            inventory_available: 0,
            inventory_in_transit: 0,
            inventory_incoming: 0,
            inventory_reserved: 0,
          })
          bundledData = [totalRow, ...bundledData.filter(row => Boolean(row.warehouse_id))]
          this.$set(this, 'bundledData', bundledData)
        }

        stockLevelsData.push({ warehouse_name: 'Total', ...inventory.total })

        for (const key in inventory.warehouses) {
          if (inventory.warehouses.hasOwnProperty(key)) {
            if (inventory.warehouses[key].available === 'in_stock') inventory.warehouses[key].available = 'In Stock'
            if (inventory.warehouses[key].stock === 'in_stock') inventory.warehouses[key].stock = 'In Stock'
            stockLevelsData.push(inventory.warehouses[key])
          }
        }
        this.$set(this, 'stockLevelsData', stockLevelsData)
        this.SET_STOCK_DATA(this.stockLevelsData)
      } catch (e) {
        throw e
      } finally {
        this.loadingInventory = false
      }
    },
  },
}